/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import com.yahoo.component.AbstractComponent;
import com.yahoo.config.model.api.PortInfo;
import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.http.InternalServerException;
import com.yahoo.yolean.Exceptions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogServerLogGrabber
extends AbstractComponent {
    private static final Logger log = Logger.getLogger(LogServerLogGrabber.class.getName());

    public String grabLog(Application application) {
        LogServerInfo logServerConnectionInfo = this.findLogserverConnectionInfo(application);
        log.log((Level)LogLevel.DEBUG, "Requested error logs, pulling from logserver on " + logServerConnectionInfo);
        try {
            return this.readLog(logServerConnectionInfo.hostName, logServerConnectionInfo.port);
        }
        catch (IOException e) {
            throw new InternalServerException(Exceptions.toMessageString((Throwable)e));
        }
    }

    private LogServerInfo findLogserverConnectionInfo(Application application) {
        ArrayList logServerConnectionInfos = new ArrayList();
        application.getModel().getHosts().forEach(host -> host.getServices().stream().filter(service -> service.getServiceType().equals("logserver")).forEach(logService -> {
            Optional<Integer> logPort = this.getErrorLogPort((ServiceInfo)logService);
            logPort.ifPresent(port -> logServerConnectionInfos.add(new LogServerInfo(host.getHostname(), (int)port)));
        }));
        if (logServerConnectionInfos.size() > 1) {
            throw new RuntimeException("Found several log server ports");
        }
        if (logServerConnectionInfos.size() == 0) {
            throw new InternalServerException("Did not find any log server in config model");
        }
        return (LogServerInfo)logServerConnectionInfos.get(0);
    }

    protected String readLog(String host, int port) throws IOException {
        int charsRead;
        Socket socket = new Socket(host, port);
        BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        StringBuilder data = new StringBuilder();
        int bufferSize = 4096;
        do {
            char[] buffer = new char[bufferSize];
            charsRead = in.read(buffer);
            data.append(new String(buffer, 0, charsRead));
        } while (charsRead == bufferSize);
        in.close();
        socket.close();
        return data.toString();
    }

    private Optional<Integer> getErrorLogPort(ServiceInfo service) {
        return service.getPorts().stream().filter(port -> port.getTags().contains("last-errors-holder")).map(PortInfo::getPort).findFirst();
    }

    private class LogServerInfo {
        String hostName;
        int port;

        LogServerInfo(String hostName, int port) {
            this.hostName = hostName;
            this.port = port;
        }

        public String toString() {
            return this.hostName + ":" + this.port;
        }
    }
}

