/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.version;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.provision.Version;
import com.yahoo.io.IOUtils;
import com.yahoo.vespa.defaults.Defaults;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class VersionState {
    private final File versionFile;

    @Inject
    public VersionState(ConfigserverConfig config) {
        this(new File(Defaults.getDefaults().underVespaHome(config.configServerDBDir()), "vespa_version"));
    }

    public VersionState(File versionFile) {
        this.versionFile = versionFile;
    }

    public boolean isUpgraded() {
        return this.currentVersion().compareTo(this.storedVersion()) > 0;
    }

    public void saveNewVersion() {
        try (FileWriter writer = new FileWriter(this.versionFile);){
            writer.write(this.currentVersion().toSerializedForm());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Version storedVersion() {
        try (FileReader reader = new FileReader(this.versionFile);){
            Version version = Version.fromString((String)IOUtils.readAll((Reader)reader));
            return version;
        }
        catch (Exception e) {
            return Version.fromIntValues((int)0, (int)0, (int)0);
        }
    }

    public Version currentVersion() {
        return Version.fromIntValues((int)6, (int)193, (int)124);
    }

    public String toString() {
        return String.format("Current version:%s, stored version:%s", this.currentVersion(), this.storedVersion());
    }
}

