/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2;

import com.google.inject.Inject;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.LoggingRequestHandler;
import com.yahoo.jdisc.application.BindingMatch;
import com.yahoo.vespa.config.server.application.TenantApplications;
import com.yahoo.vespa.config.server.http.BadRequestException;
import com.yahoo.vespa.config.server.http.HttpHandler;
import com.yahoo.vespa.config.server.http.InternalServerException;
import com.yahoo.vespa.config.server.http.Utils;
import com.yahoo.vespa.config.server.http.v2.HttpConfigRequests;
import com.yahoo.vespa.config.server.http.v2.ListTenantsResponse;
import com.yahoo.vespa.config.server.http.v2.TenantCreateResponse;
import com.yahoo.vespa.config.server.http.v2.TenantDeleteResponse;
import com.yahoo.vespa.config.server.http.v2.TenantGetResponse;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.config.server.tenant.Tenants;
import com.yahoo.yolean.Exceptions;
import java.util.List;

public class TenantHandler
extends HttpHandler {
    private static final String TENANT_NAME_REGEXP = "[\\w-]+";
    private final Tenants tenants;

    @Inject
    public TenantHandler(LoggingRequestHandler.Context ctx, Tenants tenants) {
        super(ctx);
        this.tenants = tenants;
    }

    @Override
    protected HttpResponse handlePUT(HttpRequest request) {
        TenantName tenantName = this.getAndValidateTenantFromRequest(request);
        try {
            this.tenants.addTenant(tenantName);
        }
        catch (Exception e) {
            throw new InternalServerException(Exceptions.toMessageString((Throwable)e));
        }
        return new TenantCreateResponse(tenantName);
    }

    @Override
    protected HttpResponse handleGET(HttpRequest request) {
        if (TenantHandler.isGetTenantRequest(request)) {
            TenantName tenantName = TenantHandler.getTenantNameFromRequest(request);
            Utils.checkThatTenantExists(this.tenants, tenantName);
            return new TenantGetResponse(tenantName);
        }
        if (TenantHandler.isListTenantsRequest(request)) {
            return new ListTenantsResponse(this.tenants.getAllTenantNames());
        }
        throw new BadRequestException(request.getUri().toString());
    }

    @Override
    protected HttpResponse handleDELETE(HttpRequest request) {
        TenantName tenantName = TenantHandler.getTenantNameFromRequest(request);
        Utils.checkThatTenantExists(this.tenants, tenantName);
        Tenant tenant = this.tenants.getTenant(tenantName);
        TenantApplications applicationRepo = tenant.getApplicationRepo();
        List<ApplicationId> activeApplications = applicationRepo.listApplications();
        if (activeApplications.isEmpty()) {
            try {
                this.tenants.deleteTenant(tenantName);
            }
            catch (Exception e) {
                throw new InternalServerException(Exceptions.toMessageString((Throwable)e));
            }
        } else {
            throw new BadRequestException("Cannot delete tenant '" + tenantName + "', as it has active applications: " + activeApplications);
        }
        return new TenantDeleteResponse(tenantName);
    }

    private TenantName getAndValidateTenantFromRequest(HttpRequest request) {
        TenantName tenantName = TenantHandler.getTenantNameFromRequest(request);
        this.checkThatTenantDoesNotExist(tenantName);
        this.validateTenantName(tenantName);
        return tenantName;
    }

    private void validateTenantName(TenantName tenant) {
        if (!tenant.value().matches(TENANT_NAME_REGEXP)) {
            throw new BadRequestException("Illegal tenant name: " + tenant);
        }
    }

    private void checkThatTenantDoesNotExist(TenantName tenantName) {
        if (this.tenants.checkThatTenantExists(tenantName)) {
            throw new BadRequestException("There already exists a tenant '" + tenantName + "'");
        }
    }

    private static BindingMatch<?> getBindingMatch(HttpRequest request) {
        return HttpConfigRequests.getBindingMatch(request, "http://*/application/v2/tenant/", "http://*/application/v2/tenant/*");
    }

    private static boolean isGetTenantRequest(HttpRequest request) {
        return TenantHandler.getBindingMatch(request).groupCount() == 3;
    }

    private static boolean isListTenantsRequest(HttpRequest request) {
        return TenantHandler.getBindingMatch(request).groupCount() == 2 && request.getUri().getPath().endsWith("/tenant/");
    }

    private static TenantName getTenantNameFromRequest(HttpRequest request) {
        BindingMatch<?> bm = TenantHandler.getBindingMatch(request);
        return TenantName.from((String)bm.group(2));
    }
}

