/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.google.inject.Inject;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.vespa.config.server.filedistribution.FileDistributionLock;
import com.yahoo.vespa.config.server.filedistribution.FileDistributionProvider;
import com.yahoo.vespa.curator.Curator;
import java.io.File;
import java.util.concurrent.locks.Lock;

public class FileDistributionFactory {
    private static final String lockPath = "/vespa/filedistribution/lock";
    private final String zkSpec;
    private final Lock lock;

    @Inject
    public FileDistributionFactory(Curator curator) {
        this(curator, curator.connectionSpec());
    }

    public FileDistributionFactory(Curator curator, String zkSpec) {
        this.lock = new FileDistributionLock(curator, lockPath);
        this.zkSpec = zkSpec;
    }

    public FileDistributionProvider createProvider(File applicationPackage, ApplicationId applicationId, boolean disableFileDistributor) {
        return new FileDistributionProvider(applicationPackage, this.zkSpec, applicationId.serializedForm(), this.lock, disableFileDistributor);
    }
}

