/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.host;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.server.host.HostValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HostRegistry<T>
implements HostValidator<T> {
    private static final Logger log = Logger.getLogger(HostRegistry.class.getName());
    private final Map<T, Collection<String>> key2HostsMap = new ConcurrentHashMap<T, Collection<String>>();
    private final Map<String, T> host2KeyMap = new ConcurrentHashMap<String, T>();

    public T getKeyForHost(String hostName) {
        return this.host2KeyMap.get(hostName);
    }

    public void update(T key, Collection<String> newHosts) {
        this.verifyHosts(key, newHosts);
        log.log((Level)LogLevel.DEBUG, "Setting hosts for key(" + key + "), newHosts(" + newHosts + "), currentHosts(" + this.getCurrentHosts(key) + ")");
        Collection<String> removedHosts = HostRegistry.getRemovedHosts(newHosts, this.getCurrentHosts(key));
        this.removeHosts(removedHosts);
        this.addHosts(key, newHosts);
    }

    @Override
    public void verifyHosts(T key, Collection<String> newHosts) {
        for (String host : newHosts) {
            if (!this.hostAlreadyTaken(host, key)) continue;
            throw new IllegalArgumentException("'" + key + "' tried to allocate host '" + host + "', but the host is already taken by '" + this.host2KeyMap.get(host) + "'");
        }
    }

    public void removeHostsForKey(T key) {
        Iterator<Map.Entry<T, Collection<String>>> it = this.key2HostsMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<T, Collection<String>> entry = it.next();
            if (!entry.getKey().equals(key)) continue;
            Collection<String> hosts = entry.getValue();
            it.remove();
            this.removeHosts(hosts);
        }
    }

    public Collection<String> getAllHosts() {
        return Collections.unmodifiableCollection(new ArrayList<String>(this.host2KeyMap.keySet()));
    }

    Collection<String> getCurrentHosts(T key) {
        return this.key2HostsMap.containsKey(key) ? new ArrayList<String>(this.key2HostsMap.get(key)) : new ArrayList();
    }

    private boolean hostAlreadyTaken(String host, T key) {
        return this.host2KeyMap.containsKey(host) && !key.equals(this.host2KeyMap.get(host));
    }

    private static Collection<String> getRemovedHosts(final Collection<String> newHosts, Collection<String> previousHosts) {
        return Collections2.filter(previousHosts, (Predicate)new Predicate<String>(){

            public boolean apply(String host) {
                return !newHosts.contains(host);
            }
        });
    }

    private void removeHosts(Collection<String> removedHosts) {
        for (String host : removedHosts) {
            log.log((Level)LogLevel.DEBUG, "Removing " + host);
            this.host2KeyMap.remove(host);
        }
    }

    private void addHosts(T key, Collection<String> newHosts) {
        for (String host : newHosts) {
            log.log((Level)LogLevel.DEBUG, "Adding " + host);
            this.host2KeyMap.put(host, key);
        }
        this.key2HostsMap.put(key, new ArrayList<String>(newHosts));
    }
}

