/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2;

import com.google.common.io.Files;
import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.logging.AccessLog;
import com.yahoo.io.IOUtils;
import com.yahoo.jdisc.application.UriPattern;
import com.yahoo.log.LogLevel;
import com.yahoo.slime.Slime;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.TimeoutBudget;
import com.yahoo.vespa.config.server.deploy.DeployHandlerLogger;
import com.yahoo.vespa.config.server.http.BadRequestException;
import com.yahoo.vespa.config.server.http.CompressedApplicationInputStream;
import com.yahoo.vespa.config.server.http.InternalServerException;
import com.yahoo.vespa.config.server.http.SessionHandler;
import com.yahoo.vespa.config.server.http.Utils;
import com.yahoo.vespa.config.server.http.v2.SessionCreateResponse;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.config.server.tenant.Tenants;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.logging.Level;

public class SessionCreateHandler
extends SessionHandler {
    public static final String APPLICATION_X_GZIP = "application/x-gzip";
    public static final String APPLICATION_ZIP = "application/zip";
    public static final String contentTypeHeader = "Content-Type";
    private static final String fromPattern = "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*";
    private final Tenants tenants;
    private final Duration zookeeperBarrierTimeout;

    @Inject
    public SessionCreateHandler(Executor executor, AccessLog accessLog, Tenants tenants, ConfigserverConfig configserverConfig, ApplicationRepository applicationRepository) {
        super(executor, accessLog, applicationRepository);
        this.tenants = tenants;
        this.zookeeperBarrierTimeout = Duration.ofSeconds(configserverConfig.zookeeper().barrierTimeout());
    }

    @Override
    protected HttpResponse handlePOST(HttpRequest request) {
        long sessionId;
        Slime deployLog = this.createDeployLog();
        TenantName tenantName = Utils.getTenantNameFromSessionRequest(request);
        Utils.checkThatTenantExists(this.tenants, tenantName);
        Tenant tenant = this.tenants.getTenant(tenantName);
        TimeoutBudget timeoutBudget = SessionHandler.getTimeoutBudget(request, this.zookeeperBarrierTimeout);
        DeployHandlerLogger logger = this.createLogger(request, deployLog, tenantName);
        if (request.hasProperty("from")) {
            ApplicationId applicationId = SessionCreateHandler.getFromApplicationId(request);
            sessionId = this.applicationRepository.createSessionFromExisting(tenant, logger, timeoutBudget, applicationId);
        } else {
            SessionCreateHandler.validateDataAndHeader(request);
            File tempDir = Files.createTempDir();
            File applicationDirectory = this.decompressApplication(request, tempDir);
            String name = this.getNameProperty(request, logger);
            sessionId = this.applicationRepository.createSession(tenant, timeoutBudget, applicationDirectory, name);
            this.cleanupApplicationDirectory(tempDir, logger);
        }
        return this.createResponse(request, tenantName, deployLog, sessionId);
    }

    private static ApplicationId getFromApplicationId(HttpRequest request) {
        String from = request.getProperty("from");
        if (from == null || "".equals(from)) {
            throw new BadRequestException("Parameter 'from' has illegal value '" + from + "'");
        }
        return SessionCreateHandler.getAndValidateFromParameter(URI.create(from));
    }

    private static ApplicationId getAndValidateFromParameter(URI from) {
        UriPattern.Match match = new UriPattern(fromPattern).match(from);
        if (match == null || match.groupCount() < 7) {
            throw new BadRequestException("Parameter 'from' has illegal value '" + from + "'");
        }
        return new ApplicationId.Builder().tenant(match.group(2)).applicationName(match.group(3)).instanceName(match.group(6)).build();
    }

    private DeployHandlerLogger createLogger(HttpRequest request, Slime deployLog, TenantName tenant) {
        return SessionHandler.createLogger(deployLog, request, new ApplicationId.Builder().tenant(tenant).applicationName("-").build());
    }

    private String getNameProperty(HttpRequest request, DeployLogger logger) {
        String name = request.getProperty("name");
        if (name == null) {
            name = "default";
            logger.log(LogLevel.INFO, "No application name given, using '" + name + "'");
        }
        return name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File decompressApplication(HttpRequest request, File tempDir) {
        try (CompressedApplicationInputStream application = CompressedApplicationInputStream.createFromCompressedStream(request.getData(), request.getHeader(contentTypeHeader));){
            File file = application.decompress(tempDir);
            return file;
        }
        catch (IOException e) {
            throw new InternalServerException("Unable to decompress data in body", e);
        }
    }

    private void cleanupApplicationDirectory(File tempDir, DeployLogger logger) {
        logger.log((Level)LogLevel.DEBUG, "Deleting tmp dir '" + tempDir + "'");
        if (!IOUtils.recursiveDeleteDir((File)tempDir)) {
            logger.log(LogLevel.WARNING, "Not able to delete tmp dir '" + tempDir + "'");
        }
    }

    private static void validateDataAndHeader(HttpRequest request) {
        if (request.getData() == null) {
            throw new BadRequestException("Request contains no data");
        }
        String header = request.getHeader(contentTypeHeader);
        if (header == null) {
            throw new BadRequestException("Request contains no Content-Type header");
        }
        if (!header.equals(APPLICATION_X_GZIP) && !header.equals(APPLICATION_ZIP)) {
            throw new BadRequestException("Request contains invalid Content-Type header, only 'application/x-gzip' and 'application/zip' are supported");
        }
    }

    private HttpResponse createResponse(HttpRequest request, TenantName tenantName, Slime deployLog, long sessionId) {
        return new SessionCreateResponse(tenantName, deployLog, deployLog.get()).createResponse(request.getHost(), request.getPort(), sessionId);
    }
}

