/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.filedistribution;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.FileReference;
import com.yahoo.config.model.api.FileDistribution;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.io.IOUtils;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Transport;
import com.yahoo.net.HostName;
import com.yahoo.vespa.config.Connection;
import com.yahoo.vespa.config.ConnectionPool;
import com.yahoo.vespa.config.JRTConnectionPool;
import com.yahoo.vespa.config.server.ConfigServerSpec;
import com.yahoo.vespa.config.server.filedistribution.FileDirectory;
import com.yahoo.vespa.filedistribution.FileDownloader;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class FileServer {
    private static final Logger log = Logger.getLogger(FileServer.class.getName());
    private final FileDirectory root;
    private final ExecutorService executor;
    private final FileDownloader downloader;

    @Inject
    public FileServer(ConfigserverConfig configserverConfig) {
        this(FileServer.createConnectionPool(configserverConfig), FileDistribution.getDefaultFileDBPath());
    }

    public FileServer(File rootDir) {
        this(new EmptyConnectionPool(), rootDir);
    }

    private FileServer(ConnectionPool connectionPool, File rootDir) {
        this.downloader = new FileDownloader(connectionPool);
        this.root = new FileDirectory(rootDir);
        this.executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    }

    public boolean hasFile(String fileName) {
        return this.hasFile(new FileReference(fileName));
    }

    public boolean hasFile(FileReference reference) {
        try {
            return this.root.getFile(reference).exists();
        }
        catch (IllegalArgumentException e) {
            log.warning("Failed locating file reference '" + reference + "' with error " + e.toString());
            return false;
        }
    }

    public boolean startFileServing(String fileName, Receiver target) {
        FileReference reference = new FileReference(fileName);
        File file = this.root.getFile(reference);
        if (file.exists()) {
            this.executor.execute(() -> this.serveFile(reference, target));
        }
        return false;
    }

    private void serveFile(FileReference reference, Receiver target) {
        File file = this.root.getFile(reference);
        log.info("Start serving reference '" + reference.value() + "' with file '" + file.getAbsolutePath() + "'");
        byte[] blob = new byte[]{};
        boolean success = false;
        String errorDescription = "OK";
        try {
            blob = IOUtils.readFileBytes((File)file);
            success = true;
        }
        catch (IOException e) {
            errorDescription = "For file reference '" + reference.value() + "' I failed reading file '" + file.getAbsolutePath() + "'";
            log.warning(errorDescription + "for sending to '" + target.toString() + "'. " + e.toString());
        }
        target.receive(reference, file.getName(), blob, new ReplayStatus(success ? 0 : 1, success ? "OK" : errorDescription));
        log.info("Done serving reference '" + reference.toString() + "' with file '" + file.getAbsolutePath() + "'");
    }

    public void download(FileReference fileReference) {
        this.downloader.getFile(fileReference);
    }

    public FileDownloader downloader() {
        return this.downloader;
    }

    private static ConnectionPool createConnectionPool(ConfigserverConfig configserverConfig) {
        List configServers = ConfigServerSpec.fromConfig(configserverConfig).stream().filter(spec -> !spec.getHostName().equals(HostName.getLocalhost())).map(spec -> "tcp/" + spec.getHostName() + ":" + spec.getConfigServerPort()).collect(Collectors.toList());
        return configServers.size() > 0 ? new JRTConnectionPool(new ConfigSourceSet(configServers)) : new EmptyConnectionPool();
    }

    private static class EmptyConnectionPool
    implements ConnectionPool {
        private EmptyConnectionPool() {
        }

        public void close() {
        }

        public void setError(Connection connection, int i) {
        }

        public Connection getCurrent() {
            return null;
        }

        public Connection setNewCurrentConnection() {
            return null;
        }

        public int getSize() {
            return 0;
        }

        public Supervisor getSupervisor() {
            return new Supervisor(new Transport());
        }
    }

    public static interface Receiver {
        public void receive(FileReference var1, String var2, byte[] var3, ReplayStatus var4);
    }

    public static class ReplayStatus {
        private final int code;
        private final String description;

        public ReplayStatus(int code, String description) {
            this.code = code;
            this.description = description;
        }

        public boolean ok() {
            return this.code == 0;
        }

        public int getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

