/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.google.common.collect.ImmutableList;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.Vtag;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.HostName;
import com.yahoo.config.provision.OutOfCapacityException;
import com.yahoo.config.provision.Rotation;
import com.yahoo.config.provision.Version;
import com.yahoo.config.provision.Zone;
import com.yahoo.lang.SettableOptional;
import com.yahoo.log.LogLevel;
import com.yahoo.path.Path;
import com.yahoo.vespa.config.server.ConfigServerSpec;
import com.yahoo.vespa.config.server.application.ApplicationSet;
import com.yahoo.vespa.config.server.application.PermanentApplicationPackage;
import com.yahoo.vespa.config.server.configchange.ConfigChangeActions;
import com.yahoo.vespa.config.server.deploy.ModelContextImpl;
import com.yahoo.vespa.config.server.deploy.ZooKeeperDeployer;
import com.yahoo.vespa.config.server.http.InvalidApplicationException;
import com.yahoo.vespa.config.server.modelfactory.ModelFactoryRegistry;
import com.yahoo.vespa.config.server.modelfactory.PreparedModelsBuilder;
import com.yahoo.vespa.config.server.provision.HostProvisionerProvider;
import com.yahoo.vespa.config.server.session.FileDistributionFactory;
import com.yahoo.vespa.config.server.session.PrepareParams;
import com.yahoo.vespa.config.server.session.SessionContext;
import com.yahoo.vespa.config.server.session.SessionZooKeeperClient;
import com.yahoo.vespa.config.server.tenant.Rotations;
import com.yahoo.vespa.curator.Curator;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class SessionPreparer {
    private static final Logger log = Logger.getLogger(SessionPreparer.class.getName());
    private final ModelFactoryRegistry modelFactoryRegistry;
    private final FileDistributionFactory fileDistributionFactory;
    private final HostProvisionerProvider hostProvisionerProvider;
    private final PermanentApplicationPackage permanentApplicationPackage;
    private final ConfigserverConfig configserverConfig;
    private final ConfigDefinitionRepo configDefinitionRepo;
    private final Curator curator;
    private final Zone zone;

    public SessionPreparer(ModelFactoryRegistry modelFactoryRegistry, FileDistributionFactory fileDistributionFactory, HostProvisionerProvider hostProvisionerProvider, PermanentApplicationPackage permanentApplicationPackage, ConfigserverConfig configserverConfig, ConfigDefinitionRepo configDefinitionRepo, Curator curator, Zone zone) {
        this.modelFactoryRegistry = modelFactoryRegistry;
        this.fileDistributionFactory = fileDistributionFactory;
        this.hostProvisionerProvider = hostProvisionerProvider;
        this.permanentApplicationPackage = permanentApplicationPackage;
        this.configserverConfig = configserverConfig;
        this.configDefinitionRepo = configDefinitionRepo;
        this.curator = curator;
        this.zone = zone;
    }

    public ConfigChangeActions prepare(SessionContext context, DeployLogger logger, PrepareParams params, Optional<ApplicationSet> currentActiveApplicationSet, Path tenantPath, Instant now) {
        Preparation preparation = new Preparation(context, logger, params, currentActiveApplicationSet, tenantPath);
        preparation.preprocess();
        try {
            AllocatedHosts allocatedHosts = preparation.buildModels(now);
            preparation.makeResult(allocatedHosts);
            if (!params.isDryRun()) {
                preparation.writeStateZK();
                preparation.writeRotZK();
                preparation.distribute();
                preparation.reloadDeployFileDistributor();
            }
            log.log((Level)LogLevel.DEBUG, () -> "time used " + params.getTimeoutBudget().timesUsed() + " : " + params.getApplicationId());
            return preparation.result();
        }
        catch (OutOfCapacityException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw new InvalidApplicationException("Invalid application package", e);
        }
    }

    private void writeStateToZooKeeper(SessionZooKeeperClient zooKeeperClient, ApplicationPackage applicationPackage, ApplicationId applicationId, com.yahoo.component.Version vespaVersion, DeployLogger deployLogger, Map<Version, FileRegistry> fileRegistryMap, AllocatedHosts allocatedHosts) {
        ZooKeeperDeployer zkDeployer = zooKeeperClient.createDeployer(deployLogger);
        try {
            zkDeployer.deploy(applicationPackage, fileRegistryMap, allocatedHosts);
            zooKeeperClient.writeApplicationId(applicationId);
            zooKeeperClient.writeVespaVersion(vespaVersion);
        }
        catch (IOException | RuntimeException e) {
            zkDeployer.cleanup();
            throw new RuntimeException("Error preparing session", e);
        }
    }

    private static final class ReconciliatedHostAllocations {
        public ReconciliatedHostAllocations(List<PreparedModelsBuilder.PreparedModelResult> results) {
        }
    }

    private static class PrepareResult {
        private final AllocatedHosts allocatedHosts;
        private final ImmutableList<PreparedModelsBuilder.PreparedModelResult> results;

        public PrepareResult(AllocatedHosts allocatedHosts, List<PreparedModelsBuilder.PreparedModelResult> results) {
            this.allocatedHosts = allocatedHosts;
            this.results = ImmutableList.copyOf(results);
        }

        public List<PreparedModelsBuilder.PreparedModelResult> asList() {
            return this.results;
        }

        public AllocatedHosts allocatedHosts() {
            return this.allocatedHosts;
        }

        public Map<Version, FileRegistry> getFileRegistries() {
            return this.results.stream().collect(Collectors.toMap(prepareResult -> prepareResult.version, prepareResult -> prepareResult.fileDistributionProvider.getFileRegistry()));
        }

        public ConfigChangeActions getConfigChangeActions() {
            return new ConfigChangeActions(this.results.stream().map(result -> result.actions).flatMap(actions -> actions.stream()).collect(Collectors.toList()));
        }
    }

    private class Preparation {
        final SessionContext context;
        final DeployLogger logger;
        final PrepareParams params;
        final Optional<ApplicationSet> currentActiveApplicationSet;
        final Path tenantPath;
        final ApplicationId applicationId;
        final com.yahoo.component.Version vespaVersion;
        final Rotations rotations;
        final Set<Rotation> rotationsSet;
        final ModelContext.Properties properties;
        private ApplicationPackage applicationPackage;
        private List<PreparedModelsBuilder.PreparedModelResult> modelResultList;
        private PrepareResult prepareResult;
        private final PreparedModelsBuilder preparedModelsBuilder;

        Preparation(SessionContext context, DeployLogger logger, PrepareParams params, Optional<ApplicationSet> currentActiveApplicationSet, Path tenantPath) {
            this.context = context;
            this.logger = logger;
            this.params = params;
            this.currentActiveApplicationSet = currentActiveApplicationSet;
            this.tenantPath = tenantPath;
            this.applicationId = params.getApplicationId();
            this.vespaVersion = params.vespaVersion().orElse(Vtag.currentVersion);
            this.rotations = new Rotations(SessionPreparer.this.curator, tenantPath);
            this.rotationsSet = this.getRotations(params.rotations());
            this.properties = new ModelContextImpl.Properties(params.getApplicationId(), SessionPreparer.this.configserverConfig.multitenant(), ConfigServerSpec.fromConfig(SessionPreparer.this.configserverConfig), HostName.from((String)SessionPreparer.this.configserverConfig.loadBalancerAddress()), SessionPreparer.this.configserverConfig.hostedVespa(), SessionPreparer.this.zone, this.rotationsSet);
            this.preparedModelsBuilder = new PreparedModelsBuilder(SessionPreparer.this.modelFactoryRegistry, SessionPreparer.this.permanentApplicationPackage, SessionPreparer.this.configDefinitionRepo, SessionPreparer.this.fileDistributionFactory, SessionPreparer.this.hostProvisionerProvider, context, logger, params, currentActiveApplicationSet, this.properties);
        }

        void checkTimeout(String step) {
            if (!this.params.getTimeoutBudget().hasTimeLeft()) {
                String used = this.params.getTimeoutBudget().timesUsed();
                throw new RuntimeException("prepare timed out " + used + " after " + step + " step: " + this.applicationId);
            }
        }

        void preprocess() {
            try {
                this.applicationPackage = this.context.getApplicationPackage().preprocess(this.properties.zone(), null, this.logger);
            }
            catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
                throw new RuntimeException("Error deploying application package", e);
            }
            this.checkTimeout("preprocess");
        }

        AllocatedHosts buildModels(Instant now) {
            SettableOptional allocatedHosts = new SettableOptional();
            this.modelResultList = this.preparedModelsBuilder.buildModels(this.applicationId, this.vespaVersion, this.applicationPackage, (SettableOptional<AllocatedHosts>)allocatedHosts, now);
            this.checkTimeout("build models");
            return (AllocatedHosts)allocatedHosts.get();
        }

        void makeResult(AllocatedHosts allocatedHosts) {
            this.prepareResult = new PrepareResult(allocatedHosts, this.modelResultList);
            this.checkTimeout("making result from models");
        }

        void writeStateZK() {
            log.log((Level)LogLevel.DEBUG, "Writing application package state to zookeeper");
            SessionPreparer.this.writeStateToZooKeeper(this.context.getSessionZooKeeperClient(), this.applicationPackage, this.applicationId, this.vespaVersion, this.logger, this.prepareResult.getFileRegistries(), this.prepareResult.allocatedHosts());
            this.checkTimeout("write state to zookeeper");
        }

        void writeRotZK() {
            this.rotations.writeRotationsToZooKeeper(this.applicationId, this.rotationsSet);
            this.checkTimeout("write rotations to zookeeper");
        }

        void distribute() {
            this.prepareResult.asList().forEach(modelResult -> modelResult.model.distributeFiles(modelResult.fileDistributionProvider.getFileDistribution()));
            this.checkTimeout("distribute files");
        }

        void reloadDeployFileDistributor() {
            if (this.prepareResult.asList().isEmpty()) {
                return;
            }
            PreparedModelsBuilder.PreparedModelResult aModelResult = this.prepareResult.asList().get(0);
            aModelResult.model.reloadDeployFileDistributor(aModelResult.fileDistributionProvider.getFileDistribution());
            this.checkTimeout("reload all deployed files in file distributor");
        }

        ConfigChangeActions result() {
            return this.prepareResult.getConfigChangeActions();
        }

        private Set<Rotation> getRotations(Set<Rotation> rotations) {
            if (rotations == null || rotations.isEmpty()) {
                rotations = this.rotations.readRotationsFromZooKeeper(this.applicationId);
            }
            return rotations;
        }
    }
}

