/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.zookeeper;

import com.google.common.base.Joiner;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationMetaData;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.ComponentInfo;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.application.api.UnparsedConfigDefinition;
import com.yahoo.config.codegen.CNode;
import com.yahoo.config.codegen.DefParser;
import com.yahoo.config.model.application.provider.PreGeneratedFileRegistry;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.NodeFlavors;
import com.yahoo.config.provision.Version;
import com.yahoo.io.IOUtils;
import com.yahoo.io.reader.NamedReader;
import com.yahoo.path.Path;
import com.yahoo.vespa.config.ConfigDefinition;
import com.yahoo.vespa.config.ConfigDefinitionBuilder;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.server.zookeeper.ConfigCurator;
import com.yahoo.vespa.config.server.zookeeper.ZKApplicationFile;
import com.yahoo.vespa.config.server.zookeeper.ZKLiveApp;
import com.yahoo.vespa.config.util.ConfigUtils;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ZKApplicationPackage
implements ApplicationPackage {
    private ZKLiveApp liveApp;
    private final Map<Version, PreGeneratedFileRegistry> fileRegistryMap = new HashMap<Version, PreGeneratedFileRegistry>();
    private final Optional<AllocatedHosts> allocatedHosts;
    private static final Version legacyVersion = Version.fromIntValues((int)0, (int)0, (int)0);
    public static final String fileRegistryNode = "fileregistry";
    public static final String allocatedHostsNode = "allocatedHosts";
    private final ApplicationMetaData metaData;

    public ZKApplicationPackage(ConfigCurator zk, Path appPath, Optional<NodeFlavors> nodeFlavors) {
        ZKApplicationPackage.verifyAppPath(zk, appPath);
        this.liveApp = new ZKLiveApp(zk, appPath);
        this.metaData = this.readMetaDataFromLiveApp(this.liveApp);
        this.importFileRegistries(fileRegistryNode);
        this.allocatedHosts = this.importAllocatedHosts(allocatedHostsNode, nodeFlavors);
    }

    private Optional<AllocatedHosts> importAllocatedHosts(String allocatedHostsPath, Optional<NodeFlavors> nodeFlavors) {
        if (!this.liveApp.exists(allocatedHostsPath)) {
            return Optional.empty();
        }
        return Optional.of(this.readAllocatedHosts(allocatedHostsPath, nodeFlavors));
    }

    private AllocatedHosts readAllocatedHosts(String allocatedHostsPath, Optional<NodeFlavors> nodeFlavors) {
        try {
            return AllocatedHosts.fromJson((byte[])this.liveApp.getBytes(allocatedHostsPath), nodeFlavors);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read allocated hosts", e);
        }
    }

    private void importFileRegistries(String fileRegistryNode) {
        List<String> fileRegistryNodes = this.liveApp.getChildren(fileRegistryNode);
        if (fileRegistryNodes.isEmpty()) {
            this.fileRegistryMap.put(legacyVersion, this.importFileRegistry(fileRegistryNode));
        } else {
            fileRegistryNodes.stream().forEach(version -> this.fileRegistryMap.put(Version.fromString((String)version), this.importFileRegistry(Joiner.on((String)"/").join((Object)fileRegistryNode, version, new Object[0]))));
        }
    }

    private PreGeneratedFileRegistry importFileRegistry(String fileRegistryNode) {
        try {
            return PreGeneratedFileRegistry.importRegistry((Reader)this.liveApp.getDataReader(fileRegistryNode));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not determine which files to distribute. Please try redeploying the application", e);
        }
    }

    private ApplicationMetaData readMetaDataFromLiveApp(ZKLiveApp liveApp) {
        String metaDataString = liveApp.getData("/meta");
        if (metaDataString == null || metaDataString.isEmpty()) {
            return null;
        }
        return ApplicationMetaData.fromJsonString((String)liveApp.getData("/meta"));
    }

    public ApplicationMetaData getMetaData() {
        return this.metaData;
    }

    private static void verifyAppPath(ConfigCurator zk, Path appPath) {
        if (!zk.exists(appPath.getAbsolute())) {
            throw new RuntimeException("App with path " + appPath + " does not exist");
        }
    }

    public String getApplicationName() {
        return this.metaData.getApplicationName();
    }

    public Reader getServices() {
        return this.getUserAppData("services.xml");
    }

    public Reader getHosts() {
        if (this.liveApp.exists("/userapp", "hosts.xml")) {
            return this.getUserAppData("hosts.xml");
        }
        return null;
    }

    public List<NamedReader> searchDefinitionContents() {
        ArrayList<NamedReader> ret = new ArrayList<NamedReader>();
        for (String sd : this.liveApp.getChildren("/userapp/" + SEARCH_DEFINITIONS_DIR)) {
            if (!sd.endsWith(".sd")) continue;
            ret.add(new NamedReader(sd, (Reader)new StringReader(this.liveApp.getData("/userapp/" + SEARCH_DEFINITIONS_DIR, sd))));
        }
        return ret;
    }

    public Optional<AllocatedHosts> getAllocatedHosts() {
        return this.allocatedHosts;
    }

    public Map<Version, FileRegistry> getFileRegistryMap() {
        return Collections.unmodifiableMap(this.fileRegistryMap);
    }

    private Optional<PreGeneratedFileRegistry> getPreGeneratedFileRegistry(Version vespaVersion) {
        Optional<PreGeneratedFileRegistry> fileRegistry = Optional.ofNullable(this.fileRegistryMap.get(vespaVersion));
        if (!fileRegistry.isPresent()) {
            fileRegistry = Optional.of(this.fileRegistryMap.values().iterator().next());
        }
        return fileRegistry;
    }

    public List<NamedReader> getSearchDefinitions() {
        return this.searchDefinitionContents();
    }

    private Reader retrieveConfigDefReader(String def) {
        try {
            return this.liveApp.getDataReader("/defconfigs", def);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Could not retrieve config definition " + def + ".", e);
        }
    }

    public Map<ConfigDefinitionKey, UnparsedConfigDefinition> getAllExistingConfigDefs() {
        LinkedHashMap<ConfigDefinitionKey, UnparsedConfigDefinition> ret = new LinkedHashMap<ConfigDefinitionKey, UnparsedConfigDefinition>();
        List<String> allDefs = this.liveApp.getChildren("/defconfigs");
        for (final String nodeName : allDefs) {
            final ConfigDefinitionKey key = ConfigUtils.createConfigDefinitionKeyFromZKString((String)nodeName);
            ret.put(key, new UnparsedConfigDefinition(){

                public ConfigDefinition parse() {
                    DefParser parser = new DefParser(key.getName(), ZKApplicationPackage.this.retrieveConfigDefReader(nodeName));
                    return ConfigDefinitionBuilder.createConfigDefinition((CNode)parser.getTree());
                }

                public String getUnparsedContent() {
                    try {
                        return IOUtils.readAll((Reader)ZKApplicationPackage.this.retrieveConfigDefReader(nodeName));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error retriving def file", e);
                    }
                }
            });
        }
        return ret;
    }

    public List<NamedReader> getFiles(Path relativePath, String suffix, boolean recurse) {
        return this.liveApp.getAllDataFromDirectory("/userapp/" + relativePath.getRelative(), suffix, recurse);
    }

    public ApplicationFile getFile(Path file) {
        return new ZKApplicationFile(file, this.liveApp);
    }

    public String getHostSource() {
        return "zookeeper hosts file";
    }

    public String getServicesSource() {
        return "zookeeper services file";
    }

    public Optional<Reader> getDeployment() {
        return this.optionalFile(DEPLOYMENT_FILE.getName());
    }

    public Optional<Reader> getValidationOverrides() {
        return this.optionalFile(VALIDATION_OVERRIDES.getName());
    }

    private Optional<Reader> optionalFile(String file) {
        if (this.liveApp.exists("/userapp", file)) {
            return Optional.of(this.getUserAppData(file));
        }
        return Optional.empty();
    }

    public List<ComponentInfo> getComponentsInfo(Version vespaVersion) {
        ArrayList<ComponentInfo> components = new ArrayList<ComponentInfo>();
        PreGeneratedFileRegistry fileRegistry = this.getPreGeneratedFileRegistry(vespaVersion).get();
        for (String path : fileRegistry.getPaths()) {
            if (!path.startsWith("components" + File.separator) || !path.endsWith(".jar")) continue;
            ComponentInfo component = new ComponentInfo(path);
            components.add(component);
        }
        return components;
    }

    private Reader getUserAppData(String node) {
        return this.liveApp.getDataReader("/userapp", node);
    }

    public Reader getRankingExpression(String name) {
        return this.liveApp.getDataReader("/userapp/" + SEARCH_DEFINITIONS_DIR, name);
    }

    public File getFileReference(Path pathRelativeToAppDir) {
        String fileName = this.liveApp.getData("/userapp/" + pathRelativeToAppDir.getRelative());
        return new File(fileName);
    }

    public void validateIncludeDir(String dirName) {
        String fullPath = "/userapp/" + dirName;
        if (!this.liveApp.exists(fullPath)) {
            throw new IllegalArgumentException("Cannot include directory '" + dirName + "', as it does not exist in ZooKeeper!");
        }
    }
}

