/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.modelfactory;

import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.api.ModelCreateResult;
import com.yahoo.config.model.api.ModelFactory;
import com.yahoo.config.model.application.provider.FilesApplicationPackage;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.Provisioner;
import com.yahoo.config.provision.Version;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.server.application.ApplicationSet;
import com.yahoo.vespa.config.server.application.PermanentApplicationPackage;
import com.yahoo.vespa.config.server.deploy.ModelContextImpl;
import com.yahoo.vespa.config.server.filedistribution.FileDistributionProvider;
import com.yahoo.vespa.config.server.host.HostValidator;
import com.yahoo.vespa.config.server.modelfactory.ModelFactoryRegistry;
import com.yahoo.vespa.config.server.modelfactory.ModelResult;
import com.yahoo.vespa.config.server.modelfactory.ModelsBuilder;
import com.yahoo.vespa.config.server.provision.HostProvisionerProvider;
import com.yahoo.vespa.config.server.provision.ProvisionerAdapter;
import com.yahoo.vespa.config.server.provision.StaticProvisioner;
import com.yahoo.vespa.config.server.session.FileDistributionFactory;
import com.yahoo.vespa.config.server.session.PrepareParams;
import com.yahoo.vespa.config.server.session.SessionContext;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class PreparedModelsBuilder
extends ModelsBuilder<PreparedModelResult> {
    private static final Logger log = Logger.getLogger(PreparedModelsBuilder.class.getName());
    private final PermanentApplicationPackage permanentApplicationPackage;
    private final ConfigDefinitionRepo configDefinitionRepo;
    private final SessionContext context;
    private final DeployLogger logger;
    private final PrepareParams params;
    private final FileDistributionFactory fileDistributionFactory;
    private final HostProvisionerProvider hostProvisionerProvider;
    private final Optional<ApplicationSet> currentActiveApplicationSet;
    private final ModelContext.Properties properties;

    public PreparedModelsBuilder(ModelFactoryRegistry modelFactoryRegistry, PermanentApplicationPackage permanentApplicationPackage, ConfigDefinitionRepo configDefinitionRepo, FileDistributionFactory fileDistributionFactory, HostProvisionerProvider hostProvisionerProvider, SessionContext context, DeployLogger logger, PrepareParams params, Optional<ApplicationSet> currentActiveApplicationSet, ModelContext.Properties properties) {
        super(modelFactoryRegistry, properties.hostedVespa());
        this.permanentApplicationPackage = permanentApplicationPackage;
        this.configDefinitionRepo = configDefinitionRepo;
        this.fileDistributionFactory = fileDistributionFactory;
        this.hostProvisionerProvider = hostProvisionerProvider;
        this.context = context;
        this.logger = logger;
        this.params = params;
        this.currentActiveApplicationSet = currentActiveApplicationSet;
        this.properties = properties;
    }

    @Override
    protected PreparedModelResult buildModelVersion(ModelFactory modelFactory, ApplicationPackage applicationPackage, ApplicationId applicationId, com.yahoo.component.Version wantedNodeVespaVersion, Optional<AllocatedHosts> allocatedHosts, Instant now) {
        Version modelVersion = modelFactory.getVersion();
        log.log((Level)LogLevel.DEBUG, "Building model " + modelVersion + " for " + applicationId);
        FileDistributionProvider fileDistributionProvider = this.fileDistributionFactory.createProvider(this.context.getServerDBSessionDir(), applicationId);
        Optional<HostProvisioner> hostProvisioner = this.createHostProvisioner(allocatedHosts);
        Optional<Model> previousModel = this.currentActiveApplicationSet.map(set -> set.getForVersionOrLatest(Optional.of(modelVersion), now).getModel());
        ModelContextImpl modelContext = new ModelContextImpl(applicationPackage, previousModel, this.permanentApplicationPackage.applicationPackage(), this.logger, this.configDefinitionRepo, fileDistributionProvider.getFileRegistry(), hostProvisioner, this.properties, this.getAppDir(applicationPackage), new com.yahoo.component.Version(modelVersion.toString()), wantedNodeVespaVersion);
        log.log((Level)LogLevel.DEBUG, "Create and validate model " + modelVersion + " for " + applicationId);
        ModelCreateResult result = modelFactory.createAndValidateModel((ModelContext)modelContext, this.params.ignoreValidationErrors());
        this.validateModelHosts(this.context.getHostValidator(), applicationId, result.getModel());
        log.log((Level)LogLevel.DEBUG, "Done building model " + modelVersion + " for " + applicationId);
        return new PreparedModelResult(modelVersion, result.getModel(), fileDistributionProvider, result.getConfigChangeActions());
    }

    private Optional<HostProvisioner> createHostProvisioner(Optional<AllocatedHosts> allocatedHosts) {
        Optional<HostProvisioner> nodeRepositoryProvisioner = this.createNodeRepositoryProvisioner(this.properties);
        if (!allocatedHosts.isPresent()) {
            return nodeRepositoryProvisioner;
        }
        Optional<HostProvisioner> staticProvisioner = this.createStaticProvisioner(allocatedHosts);
        if (!staticProvisioner.isPresent()) {
            return Optional.empty();
        }
        if (!nodeRepositoryProvisioner.isPresent()) {
            return Optional.of(new StaticProvisioner(allocatedHosts.get()));
        }
        return Optional.of(new StaticProvisioner(allocatedHosts.get(), nodeRepositoryProvisioner.get()));
    }

    private Optional<File> getAppDir(ApplicationPackage applicationPackage) {
        try {
            return applicationPackage instanceof FilesApplicationPackage ? Optional.of(((FilesApplicationPackage)applicationPackage).getAppDir()) : Optional.empty();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not find app dir", e);
        }
    }

    private void validateModelHosts(HostValidator<ApplicationId> hostValidator, ApplicationId applicationId, Model model) {
        hostValidator.verifyHosts(applicationId, model.getHosts().stream().map(hostInfo -> hostInfo.getHostname()).collect(Collectors.toList()));
    }

    private Optional<HostProvisioner> createNodeRepositoryProvisioner(ModelContext.Properties properties) {
        return this.hostProvisionerProvider.getHostProvisioner().map(provisioner -> new ProvisionerAdapter((Provisioner)provisioner, properties.applicationId()));
    }

    public static class PreparedModelResult
    implements ModelResult {
        public final Version version;
        public final Model model;
        public final FileDistributionProvider fileDistributionProvider;
        public final List<ConfigChangeAction> actions;

        public PreparedModelResult(Version version, Model model, FileDistributionProvider fileDistributionProvider, List<ConfigChangeAction> actions) {
            this.version = version;
            this.model = model;
            this.fileDistributionProvider = fileDistributionProvider;
            this.actions = actions;
        }

        @Override
        public Model getModel() {
            return this.model;
        }
    }
}

