/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.logging.AccessLog;
import com.yahoo.log.LogLevel;
import com.yahoo.slime.Slime;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.configchange.ConfigChangeActions;
import com.yahoo.vespa.config.server.configchange.RefeedActions;
import com.yahoo.vespa.config.server.configchange.RestartActions;
import com.yahoo.vespa.config.server.deploy.DeployHandlerLogger;
import com.yahoo.vespa.config.server.http.SessionHandler;
import com.yahoo.vespa.config.server.http.Utils;
import com.yahoo.vespa.config.server.http.v2.SessionPrepareResponse;
import com.yahoo.vespa.config.server.session.PrepareParams;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.config.server.tenant.Tenants;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SessionPrepareHandler
extends SessionHandler {
    private static final Logger log = Logger.getLogger(SessionPrepareHandler.class.getName());
    private final Tenants tenants;
    private final Duration zookeeperBarrierTimeout;

    @Inject
    public SessionPrepareHandler(Executor executor, AccessLog accessLog, Tenants tenants, ConfigserverConfig configserverConfig, ApplicationRepository applicationRepository) {
        super(executor, accessLog, applicationRepository);
        this.tenants = tenants;
        this.zookeeperBarrierTimeout = Duration.ofSeconds(configserverConfig.zookeeper().barrierTimeout());
    }

    public Duration getTimeout() {
        return this.zookeeperBarrierTimeout.plus(Duration.ofSeconds(10L));
    }

    @Override
    protected HttpResponse handlePUT(HttpRequest request) {
        Tenant tenant = this.getExistingTenant(request);
        TenantName tenantName = tenant.getName();
        long sessionId = SessionPrepareHandler.getSessionIdV2(request);
        this.applicationRepository.validateThatLocalSessionIsNotActive(tenant, sessionId);
        PrepareParams prepareParams = PrepareParams.fromHttpRequest(request, tenantName, this.zookeeperBarrierTimeout);
        ApplicationId appId = prepareParams.getApplicationId();
        Slime rawDeployLog = this.createDeployLog();
        DeployHandlerLogger logger = SessionPrepareHandler.createLogger(rawDeployLog, request.getBooleanProperty("verbose"), appId);
        ConfigChangeActions actions = this.applicationRepository.prepare(tenant, sessionId, logger, prepareParams);
        SessionPrepareHandler.logConfigChangeActions(actions, logger);
        log.log(LogLevel.INFO, Tenants.logPre(appId) + "Session " + sessionId + " prepared successfully. ");
        return new SessionPrepareResponse(rawDeployLog, tenantName, request, sessionId, actions);
    }

    private static void logConfigChangeActions(ConfigChangeActions actions, DeployLogger logger) {
        RefeedActions refeedActions;
        RestartActions restartActions = actions.getRestartActions();
        if (!restartActions.isEmpty()) {
            logger.log(Level.WARNING, "Change(s) between active and new application that require restart:\n" + restartActions.format());
        }
        if (!(refeedActions = actions.getRefeedActions()).isEmpty()) {
            boolean allAllowed = refeedActions.getEntries().stream().allMatch(RefeedActions.Entry::allowed);
            logger.log(allAllowed ? Level.INFO : Level.WARNING, "Change(s) between active and new application that may require re-feed:\n" + refeedActions.format());
        }
    }

    @Override
    protected HttpResponse handleGET(HttpRequest request) {
        Tenant tenant = this.getExistingTenant(request);
        long sessionId = SessionPrepareHandler.getSessionIdV2(request);
        this.applicationRepository.validateThatRemoteSessionIsNotActive(tenant, sessionId);
        this.applicationRepository.validateThatRemoteSessionIsPrepared(tenant, sessionId);
        return new SessionPrepareResponse(this.createDeployLog(), tenant.getName(), request, sessionId);
    }

    private Tenant getExistingTenant(HttpRequest request) {
        TenantName tenantName = Utils.getTenantNameFromSessionRequest(request);
        Utils.checkThatTenantExists(this.tenants, tenantName);
        return this.tenants.getTenant(tenantName);
    }
}

