/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import com.google.inject.Inject;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.logging.AccessLog;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.protocol.ConfigResponse;
import com.yahoo.vespa.config.server.RequestHandler;
import com.yahoo.vespa.config.server.http.HttpConfigRequest;
import com.yahoo.vespa.config.server.http.HttpConfigResponse;
import com.yahoo.vespa.config.server.http.HttpHandler;
import com.yahoo.vespa.config.server.tenant.Tenants;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.logging.Level;

public class HttpGetConfigHandler
extends HttpHandler {
    private final RequestHandler requestHandler;

    public HttpGetConfigHandler(Executor executor, RequestHandler requestHandler, AccessLog accessLog) {
        super(executor, accessLog);
        this.requestHandler = requestHandler;
    }

    @Inject
    public HttpGetConfigHandler(Executor executor, Tenants tenants, AccessLog accesslog) {
        this(executor, tenants.defaultTenant().getRequestHandler(), accesslog);
    }

    @Override
    public HttpResponse handleGET(HttpRequest req) {
        HttpConfigRequest request = HttpConfigRequest.createFromRequestV1(req);
        HttpConfigRequest.validateRequestKey(request.getConfigKey(), this.requestHandler, ApplicationId.defaultId());
        return HttpConfigResponse.createFromConfig(this.resolveConfig(request));
    }

    private ConfigResponse resolveConfig(HttpConfigRequest request) {
        this.log.log((Level)LogLevel.DEBUG, "nocache=" + request.noCache());
        ConfigResponse config = this.requestHandler.resolveConfig(ApplicationId.defaultId(), request, Optional.empty());
        if (config == null) {
            HttpConfigRequest.throwModelNotReady();
        }
        return config;
    }
}

