/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.filedistribution;

import com.yahoo.config.FileReference;
import com.yahoo.config.model.api.FileDistribution;
import com.yahoo.vespa.filedistribution.FileDistributionManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public class FileDBHandler
implements FileDistribution {
    private final FileDistributionManager manager;

    public FileDBHandler(FileDistributionManager manager) {
        this.manager = manager;
    }

    public void sendDeployedFiles(String hostName, Set<FileReference> fileReferences) {
        ArrayList<String> referencesAsString = new ArrayList<String>();
        for (FileReference reference : fileReferences) {
            referencesAsString.add(reference.value());
        }
        this.manager.setDeployedFiles(hostName, referencesAsString);
    }

    public void removeDeploymentsThatHaveDifferentApplicationId(Collection<String> targetHostnames) {
        this.manager.removeDeploymentsThatHaveDifferentApplicationId(targetHostnames);
    }

    public void reloadDeployFileDistributor() {
        this.manager.reloadDeployFileDistributor();
    }
}

