/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.provision.TenantName;
import com.yahoo.path.Path;
import com.yahoo.vespa.config.server.GlobalComponentRegistry;
import com.yahoo.vespa.config.server.session.RemoteSession;
import com.yahoo.vespa.config.server.session.SessionZooKeeperClient;
import com.yahoo.vespa.config.server.zookeeper.ConfigCurator;
import com.yahoo.vespa.curator.Curator;
import java.time.Clock;

public class RemoteSessionFactory {
    private final GlobalComponentRegistry componentRegistry;
    private final Curator curator;
    private final ConfigCurator configCurator;
    private final Path sessionDirPath;
    private final ConfigDefinitionRepo defRepo;
    private final TenantName tenant;
    private final ConfigserverConfig configserverConfig;
    private final Clock clock;

    public RemoteSessionFactory(GlobalComponentRegistry componentRegistry, Path sessionsPath, TenantName tenant, Clock clock) {
        this.componentRegistry = componentRegistry;
        this.curator = componentRegistry.getCurator();
        this.configCurator = componentRegistry.getConfigCurator();
        this.sessionDirPath = sessionsPath;
        this.tenant = tenant;
        this.defRepo = componentRegistry.getConfigDefinitionRepo();
        this.configserverConfig = componentRegistry.getConfigserverConfig();
        this.clock = clock;
    }

    public RemoteSession createSession(long sessionId) {
        Path sessionPath = this.sessionDirPath.append(String.valueOf(sessionId));
        SessionZooKeeperClient sessionZKClient = new SessionZooKeeperClient(this.curator, this.configCurator, sessionPath, this.defRepo, this.configserverConfig.serverId(), this.componentRegistry.getZone().nodeFlavors());
        return new RemoteSession(this.tenant, sessionId, this.componentRegistry, sessionZKClient, this.clock);
    }
}

