/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.filedistribution;

import com.google.inject.Inject;
import com.yahoo.config.FileReference;
import com.yahoo.config.model.api.FileDistribution;
import com.yahoo.io.IOUtils;
import com.yahoo.vespa.config.server.filedistribution.FileDirectory;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;

public class FileServer {
    private static final Logger log = Logger.getLogger(FileServer.class.getName());
    private final FileDirectory root;
    private final ExecutorService executor;

    @Inject
    public FileServer() {
        this(FileDistribution.getDefaultFileDBPath());
    }

    public FileServer(File rootDir) {
        this(rootDir, Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()));
    }

    public FileServer(File rootDir, ExecutorService executor) {
        this.root = new FileDirectory(rootDir);
        this.executor = executor;
    }

    public boolean hasFile(String fileName) {
        return this.hasFile(new FileReference(fileName));
    }

    public boolean hasFile(FileReference reference) {
        try {
            return this.root.getFile(reference).exists();
        }
        catch (IllegalArgumentException e) {
            log.warning("Failed locating file reference '" + reference + "' with error " + e.toString());
            return false;
        }
    }

    public boolean startFileServing(String fileName, Receiver target) {
        FileReference reference = new FileReference(fileName);
        File file = this.root.getFile(reference);
        if (file.exists()) {
            this.executor.execute(() -> this.serveFile(reference, target));
        }
        return false;
    }

    private void serveFile(FileReference reference, Receiver target) {
        File file = this.root.getFile(reference);
        log.info("Start serving reference '" + reference.value() + "' with file '" + file.getAbsolutePath() + "'");
        byte[] blob = new byte[]{};
        boolean success = false;
        String errorDescription = "OK";
        try {
            blob = IOUtils.readFileBytes((File)file);
            success = true;
        }
        catch (IOException e) {
            errorDescription = "For file reference '" + reference.value() + "' I failed reading file '" + file.getAbsolutePath() + "'";
            log.warning(errorDescription + "for sending to '" + target.toString() + "'. " + e.toString());
        }
        target.receive(reference, file.getName(), blob, new ReplayStatus(success ? 0 : 1, success ? "OK" : errorDescription));
        log.info("Done serving reference '" + reference.toString() + "' with file '" + file.getAbsolutePath() + "'");
    }

    public static interface Receiver {
        public void receive(FileReference var1, String var2, byte[] var3, ReplayStatus var4);
    }

    public static class ReplayStatus {
        private final int code;
        private final String description;

        public ReplayStatus(int code, String description) {
            this.code = code;
            this.description = description;
        }

        public boolean ok() {
            return this.code == 0;
        }

        public int getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

