/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2;

import com.yahoo.jdisc.application.BindingMatch;
import com.yahoo.jdisc.application.UriPattern;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.vespa.config.server.RequestHandler;
import com.yahoo.vespa.config.server.http.NotFoundException;
import com.yahoo.vespa.config.server.http.v2.TenantRequest;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.config.server.tenant.Tenants;
import java.net.URI;

public class HttpConfigRequests {
    static final String RECURSIVE_QUERY_PROPERTY = "recursive";

    public static BindingMatch<?> getBindingMatch(com.yahoo.container.jdisc.HttpRequest req, String ... patterns) {
        HttpRequest jDiscRequest = req.getJDiscRequest();
        if (jDiscRequest == null) {
            throw new IllegalArgumentException("No JDisc request for: " + req.getUri());
        }
        BindingMatch jdBm = jDiscRequest.getBindingMatch();
        if (jdBm != null) {
            return jdBm;
        }
        for (String pattern : patterns) {
            UriPattern fullAppIdPattern = new UriPattern(pattern);
            URI uri = req.getUri();
            UriPattern.Match match = fullAppIdPattern.match(uri);
            if (match == null) continue;
            return new BindingMatch(match, new Object());
        }
        throw new IllegalArgumentException("Illegal url for config request: " + req.getUri());
    }

    static RequestHandler getRequestHandler(Tenants tenants, TenantRequest request) {
        Tenant tenant = tenants.getTenant(request.getApplicationId().tenant());
        if (tenant == null) {
            throw new NotFoundException("No such tenant: " + request.getApplicationId().tenant());
        }
        return tenant.getRequestHandler();
    }
}

