/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.tenant;

import com.yahoo.config.provision.TenantName;
import com.yahoo.path.Path;
import com.yahoo.vespa.config.server.ReloadHandler;
import com.yahoo.vespa.config.server.RequestHandler;
import com.yahoo.vespa.config.server.application.TenantApplications;
import com.yahoo.vespa.config.server.deploy.TenantFileSystemDirs;
import com.yahoo.vespa.config.server.session.LocalSessionRepo;
import com.yahoo.vespa.config.server.session.RemoteSessionRepo;
import com.yahoo.vespa.config.server.session.SessionFactory;
import com.yahoo.vespa.config.server.tenant.ActivateLock;
import com.yahoo.vespa.config.server.tenant.TenantHandlerProvider;
import com.yahoo.vespa.curator.Curator;
import java.util.logging.Logger;

public class Tenant
implements TenantHandlerProvider {
    private static final Logger log = Logger.getLogger(Tenant.class.getName());
    public static final String SESSIONS = "sessions";
    public static final String APPLICATIONS = "applications";
    private final TenantName name;
    private final RemoteSessionRepo remoteSessionRepo;
    private final Path path;
    private final SessionFactory sessionFactory;
    private final LocalSessionRepo localSessionRepo;
    private final TenantApplications applicationRepo;
    private final ActivateLock activateLock;
    private final RequestHandler requestHandler;
    private final ReloadHandler reloadHandler;
    private final TenantFileSystemDirs tenantFileSystemDirs;
    private final Curator curator;

    Tenant(TenantName name, Path path, SessionFactory sessionFactory, LocalSessionRepo localSessionRepo, RemoteSessionRepo remoteSessionRepo, RequestHandler requestHandler, ReloadHandler reloadHandler, TenantApplications applicationRepo, Curator curator, TenantFileSystemDirs tenantFileSystemDirs) {
        this.name = name;
        this.path = path;
        this.requestHandler = requestHandler;
        this.reloadHandler = reloadHandler;
        this.remoteSessionRepo = remoteSessionRepo;
        this.sessionFactory = sessionFactory;
        this.localSessionRepo = localSessionRepo;
        this.activateLock = new ActivateLock(curator, path);
        this.applicationRepo = applicationRepo;
        this.tenantFileSystemDirs = tenantFileSystemDirs;
        this.curator = curator;
    }

    @Override
    public ReloadHandler getReloadHandler() {
        return this.reloadHandler;
    }

    @Override
    public RequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    public RemoteSessionRepo getRemoteSessionRepo() {
        return this.remoteSessionRepo;
    }

    public TenantName getName() {
        return this.name;
    }

    public Path getPath() {
        return this.path;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public LocalSessionRepo getLocalSessionRepo() {
        return this.localSessionRepo;
    }

    public ActivateLock getActivateLock() {
        return this.activateLock;
    }

    public String toString() {
        return this.getName().value();
    }

    public TenantApplications getApplicationRepo() {
        return this.applicationRepo;
    }

    public Curator getCurator() {
        return this.curator;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Tenant)) {
            return false;
        }
        Tenant that = (Tenant)other;
        return this.name.equals((Object)that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void close() {
        this.tenantFileSystemDirs.delete();
        this.remoteSessionRepo.close();
        this.applicationRepo.close();
    }

    public void delete() {
        this.localSessionRepo.deleteAllSessions();
        this.curator.delete(this.path);
    }
}

