/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.filedistribution;

import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.FileDistribution;
import com.yahoo.vespa.config.server.filedistribution.FileDBHandler;
import com.yahoo.vespa.config.server.filedistribution.FileDBRegistry;
import com.yahoo.vespa.filedistribution.FileDistributionManager;
import java.io.File;
import java.util.concurrent.locks.Lock;

public class FileDistributionProvider {
    private final FileRegistry fileRegistry;
    private final FileDistribution fileDistribution;

    public FileDistributionProvider(File applicationDir, String zooKeepersSpec, String applicationId, Lock fileDistributionLock) {
        this.ensureDirExists(FileDistribution.getDefaultFileDBPath());
        FileDistributionManager manager = new FileDistributionManager(FileDistribution.getDefaultFileDBPath(), applicationDir, zooKeepersSpec, applicationId, fileDistributionLock);
        this.fileDistribution = new FileDBHandler(manager);
        this.fileRegistry = new FileDBRegistry(manager);
    }

    public FileDistributionProvider(FileRegistry fileRegistry, FileDistribution fileDistribution) {
        this.fileRegistry = fileRegistry;
        this.fileDistribution = fileDistribution;
    }

    public FileRegistry getFileRegistry() {
        return this.fileRegistry;
    }

    public FileDistribution getFileDistribution() {
        return this.fileDistribution;
    }

    private void ensureDirExists(File dir) {
        boolean success;
        if (!dir.exists() && !(success = dir.mkdirs())) {
            throw new RuntimeException("Could not create directory " + dir.getPath());
        }
    }
}

