/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.filedistribution;

import com.yahoo.vespa.config.server.TimeoutBudget;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.recipes.CuratorLock;
import com.yahoo.vespa.curator.recipes.CuratorLockException;
import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class FileDistributionLock
implements Lock {
    private final Lock processLock = new ReentrantLock();
    private final CuratorLock curatorLock;

    public FileDistributionLock(Curator curator, String zkPath) {
        this.curatorLock = new CuratorLock(curator, zkPath);
    }

    @Override
    public void lock() {
        this.processLock.lock();
        try {
            this.curatorLock.lock();
        }
        catch (CuratorLockException e) {
            this.processLock.unlock();
            throw e;
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean tryLock() {
        if (this.processLock.tryLock()) {
            if (this.curatorLock.tryLock()) {
                return true;
            }
            this.processLock.unlock();
            return false;
        }
        return false;
    }

    @Override
    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        TimeoutBudget budget = new TimeoutBudget(Clock.systemUTC(), Duration.ofMillis(unit.toMillis(timeout)));
        if (this.processLock.tryLock(budget.timeLeft().toMillis(), TimeUnit.MILLISECONDS)) {
            if (this.curatorLock.tryLock(budget.timeLeft().toMillis(), TimeUnit.MILLISECONDS)) {
                return true;
            }
            this.processLock.unlock();
            return false;
        }
        return false;
    }

    @Override
    public void unlock() {
        try {
            this.curatorLock.unlock();
        }
        finally {
            this.processLock.unlock();
        }
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }
}

