/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.model.api.ApplicationInfo;
import com.yahoo.config.model.api.SuperModel;
import com.yahoo.config.model.api.SuperModelListener;
import com.yahoo.config.model.api.SuperModelProvider;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.NodeFlavors;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.Zone;
import com.yahoo.vespa.config.GenerationCounter;
import com.yahoo.vespa.config.server.application.ApplicationSet;
import com.yahoo.vespa.config.server.model.SuperModelConfigProvider;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class SuperModelManager
implements SuperModelProvider {
    private final Zone zone;
    private SuperModelConfigProvider superModelConfigProvider;
    private final List<SuperModelListener> listeners = new ArrayList<SuperModelListener>();
    private long generation;
    private final long masterGeneration;
    private final GenerationCounter generationCounter;

    @Inject
    public SuperModelManager(ConfigserverConfig configserverConfig, NodeFlavors nodeFlavors, GenerationCounter generationCounter) {
        this.zone = new Zone(configserverConfig, nodeFlavors);
        this.generationCounter = generationCounter;
        this.masterGeneration = configserverConfig.masterGeneration();
        this.makeNewSuperModelConfigProvider(new SuperModel());
    }

    public synchronized SuperModel getSuperModel() {
        return this.superModelConfigProvider.getSuperModel();
    }

    public synchronized SuperModelConfigProvider getSuperModelConfigProvider() {
        return this.superModelConfigProvider;
    }

    public synchronized long getGeneration() {
        return this.generation;
    }

    public synchronized SuperModel snapshot(SuperModelListener listener) {
        this.listeners.add(listener);
        return this.superModelConfigProvider.getSuperModel();
    }

    public Zone getZone() {
        return this.zone;
    }

    public synchronized void configActivated(TenantName tenant, ApplicationSet applicationSet) {
        ApplicationInfo applicationInfo = applicationSet.getForVersionOrLatest(Optional.empty(), Instant.now()).toApplicationInfo();
        SuperModel newSuperModel = this.superModelConfigProvider.getSuperModel().cloneAndSetApplication(applicationInfo);
        this.makeNewSuperModelConfigProvider(newSuperModel);
        this.listeners.stream().forEach(listener -> listener.applicationActivated(newSuperModel, applicationInfo.getApplicationId()));
    }

    public synchronized void applicationRemoved(ApplicationId applicationId) {
        SuperModel newSuperModel = this.superModelConfigProvider.getSuperModel().cloneAndRemoveApplication(applicationId);
        this.makeNewSuperModelConfigProvider(newSuperModel);
        this.listeners.stream().forEach(listener -> listener.applicationRemoved(newSuperModel, applicationId));
    }

    private void makeNewSuperModelConfigProvider(SuperModel newSuperModel) {
        this.generation = this.masterGeneration + this.generationCounter.get();
        this.superModelConfigProvider = new SuperModelConfigProvider(newSuperModel, this.zone);
    }
}

