/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.codegen.DefParser;
import com.yahoo.config.codegen.InnerCNode;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.GetConfigRequest;
import com.yahoo.vespa.config.buildergen.ConfigDefinition;
import com.yahoo.vespa.config.protocol.ConfigResponse;
import com.yahoo.vespa.config.protocol.DefContent;
import com.yahoo.vespa.config.server.UnknownConfigDefinitionException;
import com.yahoo.vespa.config.server.model.SuperModel;
import com.yahoo.vespa.config.server.rpc.ConfigResponseFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class SuperModelController {
    private final SuperModel model;
    private final long generation;
    private final ConfigDefinitionRepo configDefinitionRepo;
    private final ConfigResponseFactory responseFactory;

    public SuperModelController(SuperModel model, ConfigDefinitionRepo configDefinitionRepo, long generation, ConfigResponseFactory responseFactory) {
        this.model = model;
        this.configDefinitionRepo = configDefinitionRepo;
        this.generation = generation;
        this.responseFactory = responseFactory;
    }

    public ConfigResponse resolveConfig(GetConfigRequest request) {
        ConfigKey configKey = request.getConfigKey();
        InnerCNode targetDef = this.getConfigDefinition(request.getConfigKey(), request.getDefContent());
        ConfigPayload payload = this.model.getConfig(configKey);
        return this.responseFactory.createResponse(payload, targetDef, this.generation);
    }

    private InnerCNode getConfigDefinition(ConfigKey<?> configKey, DefContent defContent) {
        if (defContent.isEmpty()) {
            ConfigDefinitionKey configDefinitionKey = new ConfigDefinitionKey(configKey.getName(), configKey.getNamespace());
            ConfigDefinition configDefinition = (ConfigDefinition)this.configDefinitionRepo.getConfigDefinitions().get(configDefinitionKey);
            if (configDefinition == null) {
                throw new UnknownConfigDefinitionException("Unable to find config definition for '" + configKey.getNamespace() + "." + configKey.getName());
            }
            return configDefinition.getCNode();
        }
        DefParser dParser = new DefParser(configKey.getName(), (Reader)new StringReader(defContent.asString()));
        return dParser.getTree();
    }

    public SuperModel getSuperModel() {
        return this.model;
    }

    long getGeneration() {
        return this.generation;
    }

    public <CONFIGTYPE extends ConfigInstance> CONFIGTYPE getConfig(Class<CONFIGTYPE> configClass, ApplicationId applicationId, String configId) throws IOException {
        return this.model.getConfig(configClass, applicationId, configId);
    }
}

