/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.component.Version;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.Rotation;
import com.yahoo.config.provision.TenantName;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.vespa.config.server.TimeoutBudget;
import com.yahoo.vespa.config.server.http.SessionHandler;
import java.time.Clock;
import java.time.Duration;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;

public final class PrepareParams {
    static final String APPLICATION_NAME_PARAM_NAME = "applicationName";
    static final String INSTANCE_PARAM_NAME = "instance";
    static final String IGNORE_VALIDATION_PARAM_NAME = "ignoreValidationErrors";
    static final String DRY_RUN_PARAM_NAME = "dryRun";
    static final String VESPA_VERSION_PARAM_NAME = "vespaVersion";
    static final String ROTATIONS_PARAM_NAME = "rotations";
    private final ApplicationId applicationId;
    private final TimeoutBudget timeoutBudget;
    private final boolean ignoreValidationErrors;
    private final boolean dryRun;
    private final Optional<Version> vespaVersion;
    private final Set<Rotation> rotations;

    private PrepareParams(ApplicationId applicationId, TimeoutBudget timeoutBudget, boolean ignoreValidationErrors, boolean dryRun, Optional<Version> vespaVersion, Set<Rotation> rotations) {
        this.timeoutBudget = timeoutBudget;
        this.applicationId = applicationId;
        this.ignoreValidationErrors = ignoreValidationErrors;
        this.dryRun = dryRun;
        this.vespaVersion = vespaVersion;
        this.rotations = rotations;
    }

    public static PrepareParams fromHttpRequest(HttpRequest request, TenantName tenant, Duration barrierTimeout) {
        return new Builder().ignoreValidationErrors(request.getBooleanProperty(IGNORE_VALIDATION_PARAM_NAME)).dryRun(request.getBooleanProperty(DRY_RUN_PARAM_NAME)).timeoutBudget(SessionHandler.getTimeoutBudget(request, barrierTimeout)).applicationId(PrepareParams.createApplicationId(request, tenant)).vespaVersion(request.getProperty(VESPA_VERSION_PARAM_NAME)).rotations(request.getProperty(ROTATIONS_PARAM_NAME)).build();
    }

    private static ApplicationId createApplicationId(HttpRequest request, TenantName tenant) {
        return new ApplicationId.Builder().tenant(tenant).applicationName(PrepareParams.getPropertyWithDefault(request, APPLICATION_NAME_PARAM_NAME, "default")).instanceName(PrepareParams.getPropertyWithDefault(request, INSTANCE_PARAM_NAME, "default")).build();
    }

    private static String getPropertyWithDefault(HttpRequest request, String propertyName, String defaultProperty) {
        return PrepareParams.getProperty(request, propertyName).orElse(defaultProperty);
    }

    private static Optional<String> getProperty(HttpRequest request, String propertyName) {
        return Optional.ofNullable(request.getProperty(propertyName));
    }

    public String getApplicationName() {
        return this.applicationId.application().value();
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public Optional<Version> vespaVersion() {
        return this.vespaVersion;
    }

    public Set<Rotation> rotations() {
        return this.rotations;
    }

    public boolean ignoreValidationErrors() {
        return this.ignoreValidationErrors;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public TimeoutBudget getTimeoutBudget() {
        return this.timeoutBudget;
    }

    public static class Builder {
        private boolean ignoreValidationErrors = false;
        private boolean dryRun = false;
        private ApplicationId applicationId = ApplicationId.defaultId();
        private TimeoutBudget timeoutBudget = new TimeoutBudget(Clock.systemUTC(), Duration.ofSeconds(30L));
        private Optional<Version> vespaVersion = Optional.empty();
        private Set<Rotation> rotations;

        public Builder applicationId(ApplicationId applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder ignoreValidationErrors(boolean ignoreValidationErrors) {
            this.ignoreValidationErrors = ignoreValidationErrors;
            return this;
        }

        public Builder dryRun(boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public Builder timeoutBudget(TimeoutBudget timeoutBudget) {
            this.timeoutBudget = timeoutBudget;
            return this;
        }

        public Builder vespaVersion(String vespaVersion) {
            Optional<Object> version = Optional.empty();
            if (vespaVersion != null && !vespaVersion.isEmpty()) {
                version = Optional.of(Version.fromString((String)vespaVersion));
            }
            this.vespaVersion = version;
            return this;
        }

        public Builder rotations(String rotationsString) {
            this.rotations = new LinkedHashSet<Rotation>();
            if (rotationsString != null && !rotationsString.isEmpty()) {
                String[] rotations;
                for (String s : rotations = rotationsString.split(",")) {
                    this.rotations.add(new Rotation(s));
                }
            }
            return this;
        }

        public PrepareParams build() {
            return new PrepareParams(this.applicationId, this.timeoutBudget, this.ignoreValidationErrors, this.dryRun, this.vespaVersion, this.rotations);
        }
    }
}

