/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.provision.Provisioner;
import com.yahoo.config.provision.Zone;
import com.yahoo.vespa.config.server.ConfigServerDB;
import com.yahoo.vespa.config.server.GlobalComponentRegistry;
import com.yahoo.vespa.config.server.ReloadListener;
import com.yahoo.vespa.config.server.SuperModelGenerationCounter;
import com.yahoo.vespa.config.server.application.PermanentApplicationPackage;
import com.yahoo.vespa.config.server.host.HostRegistries;
import com.yahoo.vespa.config.server.modelfactory.ModelFactoryRegistry;
import com.yahoo.vespa.config.server.monitoring.Metrics;
import com.yahoo.vespa.config.server.provision.HostProvisionerProvider;
import com.yahoo.vespa.config.server.rpc.RpcServer;
import com.yahoo.vespa.config.server.session.SessionPreparer;
import com.yahoo.vespa.config.server.tenant.TenantListener;
import com.yahoo.vespa.config.server.zookeeper.ConfigCurator;
import com.yahoo.vespa.curator.Curator;
import java.util.Optional;

public class InjectedGlobalComponentRegistry
implements GlobalComponentRegistry {
    private final Curator curator;
    private final ConfigCurator configCurator;
    private final Metrics metrics;
    private final ModelFactoryRegistry modelFactoryRegistry;
    private final ConfigServerDB serverDB;
    private final SessionPreparer sessionPreparer;
    private final RpcServer rpcServer;
    private final ConfigserverConfig configserverConfig;
    private final SuperModelGenerationCounter superModelGenerationCounter;
    private final ConfigDefinitionRepo defRepo;
    private final PermanentApplicationPackage permanentApplicationPackage;
    private final HostRegistries hostRegistries;
    private final Optional<Provisioner> hostProvisioner;
    private final Zone zone;

    @Inject
    public InjectedGlobalComponentRegistry(Curator curator, ConfigCurator configCurator, Metrics metrics, ModelFactoryRegistry modelFactoryRegistry, ConfigServerDB serverDB, SessionPreparer sessionPreparer, RpcServer rpcServer, ConfigserverConfig configserverConfig, SuperModelGenerationCounter superModelGenerationCounter, ConfigDefinitionRepo defRepo, PermanentApplicationPackage permanentApplicationPackage, HostRegistries hostRegistries, HostProvisionerProvider hostProvisionerProvider, Zone zone) {
        this.curator = curator;
        this.configCurator = configCurator;
        this.metrics = metrics;
        this.modelFactoryRegistry = modelFactoryRegistry;
        this.serverDB = serverDB;
        this.sessionPreparer = sessionPreparer;
        this.rpcServer = rpcServer;
        this.configserverConfig = configserverConfig;
        this.superModelGenerationCounter = superModelGenerationCounter;
        this.defRepo = defRepo;
        this.permanentApplicationPackage = permanentApplicationPackage;
        this.hostRegistries = hostRegistries;
        this.hostProvisioner = hostProvisionerProvider.getHostProvisioner();
        this.zone = zone;
    }

    @Override
    public Curator getCurator() {
        return this.curator;
    }

    @Override
    public ConfigCurator getConfigCurator() {
        return this.configCurator;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public ConfigServerDB getServerDB() {
        return this.serverDB;
    }

    @Override
    public SessionPreparer getSessionPreparer() {
        return this.sessionPreparer;
    }

    @Override
    public ConfigserverConfig getConfigserverConfig() {
        return this.configserverConfig;
    }

    @Override
    public TenantListener getTenantListener() {
        return this.rpcServer;
    }

    @Override
    public ReloadListener getReloadListener() {
        return this.rpcServer;
    }

    @Override
    public SuperModelGenerationCounter getSuperModelGenerationCounter() {
        return this.superModelGenerationCounter;
    }

    @Override
    public ConfigDefinitionRepo getConfigDefinitionRepo() {
        return this.defRepo;
    }

    @Override
    public PermanentApplicationPackage getPermanentApplicationPackage() {
        return this.permanentApplicationPackage;
    }

    @Override
    public HostRegistries getHostRegistries() {
        return this.hostRegistries;
    }

    @Override
    public ModelFactoryRegistry getModelFactoryRegistry() {
        return this.modelFactoryRegistry;
    }

    @Override
    public Optional<Provisioner> getHostProvisioner() {
        return this.hostProvisioner;
    }

    @Override
    public Zone getZone() {
        return this.zone;
    }
}

