/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.configserver.flags.db;

import com.yahoo.component.AbstractComponent;
import com.yahoo.component.annotation.Inject;
import com.yahoo.path.Path;
import com.yahoo.vespa.configserver.flags.FlagsDb;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.json.FlagData;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.curator.framework.recipes.cache.ChildData;

public class FlagsDbImpl
extends AbstractComponent
implements FlagsDb {
    private static final Path ROOT_PATH = Path.fromString((String)"/flags/v1");
    private final Curator curator;
    private final Curator.DirectoryCache cache;

    @Inject
    public FlagsDbImpl(Curator curator) {
        this.curator = curator;
        curator.create(ROOT_PATH);
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        this.cache = curator.createDirectoryCache(ROOT_PATH.getAbsolute(), true, false, executorService);
        this.cache.start();
    }

    @Override
    public Optional<FlagData> getValue(FlagId flagId) {
        return Optional.ofNullable(this.cache.getCurrentData(FlagsDbImpl.getZkPathFor(flagId))).map(ChildData::getData).map(FlagData::deserializeUtf8Json);
    }

    @Override
    public void setValue(FlagId flagId, FlagData data) {
        this.curator.set(FlagsDbImpl.getZkPathFor(flagId), data.serializeToUtf8Json());
    }

    public Map<FlagId, FlagData> getAllFlagData() {
        List dataList = this.cache.getCurrentData();
        return dataList.stream().map(ChildData::getData).map(FlagData::deserializeUtf8Json).collect(Collectors.toMap(FlagData::id, Function.identity()));
    }

    @Override
    public void removeValue(FlagId flagId) {
        this.curator.delete(FlagsDbImpl.getZkPathFor(flagId));
    }

    private static Path getZkPathFor(FlagId flagId) {
        return ROOT_PATH.append(flagId.toString());
    }

    public void deconstruct() {
        this.cache.close();
    }
}

