/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.configserver.flags.http;

import com.yahoo.component.annotation.Inject;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.restapi.ErrorResponse;
import com.yahoo.restapi.Path;
import com.yahoo.vespa.configserver.flags.FlagsDb;
import com.yahoo.vespa.configserver.flags.http.DefinedFlag;
import com.yahoo.vespa.configserver.flags.http.DefinedFlags;
import com.yahoo.vespa.configserver.flags.http.FlagDataListResponse;
import com.yahoo.vespa.configserver.flags.http.FlagDataResponse;
import com.yahoo.vespa.configserver.flags.http.OKResponse;
import com.yahoo.vespa.configserver.flags.http.V1Response;
import com.yahoo.vespa.flags.Deserializer;
import com.yahoo.vespa.flags.FlagDefinition;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.Flags;
import com.yahoo.vespa.flags.json.FlagData;
import com.yahoo.yolean.Exceptions;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;

public class FlagsHandler
extends ThreadedHttpRequestHandler {
    private final FlagsDb flagsDb;

    @Inject
    public FlagsHandler(ThreadedHttpRequestHandler.Context context, FlagsDb flagsDb) {
        super(context);
        this.flagsDb = flagsDb;
    }

    public HttpResponse handle(HttpRequest request) {
        try {
            switch (request.getMethod()) {
                case GET: {
                    return this.handleGET(request);
                }
                case DELETE: {
                    return this.handleDELETE(request);
                }
                case PUT: {
                    return this.handlePUT(request);
                }
            }
            return ErrorResponse.methodNotAllowed((String)("Method '" + String.valueOf(request.getMethod()) + "' is not supported"));
        }
        catch (IllegalArgumentException e) {
            return ErrorResponse.badRequest((String)Exceptions.toMessageString((Throwable)e));
        }
        catch (RuntimeException e) {
            this.log.log(Level.WARNING, "Unexpected error handling '" + String.valueOf(request.getUri()) + "'", e);
            return ErrorResponse.internalServerError((String)Exceptions.toMessageString((Throwable)e));
        }
    }

    private HttpResponse handleGET(HttpRequest request) {
        Path path = new Path(request.getUri());
        if (path.matches("/flags/v1")) {
            return new V1Response(this.flagsV1Uri(request), "data", "defined");
        }
        if (path.matches("/flags/v1/data")) {
            return this.getFlagDataList(request);
        }
        if (path.matches("/flags/v1/data/{flagId}")) {
            return this.getFlagData(this.findFlagId(request, path));
        }
        if (path.matches("/flags/v1/defined")) {
            return new DefinedFlags(Flags.getAllFlags());
        }
        if (path.matches("/flags/v1/defined/{flagId}")) {
            return this.getDefinedFlag(this.findFlagId(request, path));
        }
        return ErrorResponse.notFoundError((String)("Nothing at path '" + String.valueOf(path) + "'"));
    }

    private HttpResponse handlePUT(HttpRequest request) {
        Path path = new Path(request.getUri());
        if (path.matches("/flags/v1/data/{flagId}")) {
            return this.putFlagData(request, this.findFlagId(request, path));
        }
        return ErrorResponse.notFoundError((String)("Nothing at path '" + String.valueOf(path) + "'"));
    }

    private HttpResponse handleDELETE(HttpRequest request) {
        Path path = new Path(request.getUri());
        if (path.matches("/flags/v1/data/{flagId}")) {
            return this.deleteFlagData(this.findFlagId(request, path));
        }
        return ErrorResponse.notFoundError((String)("Nothing at path '" + String.valueOf(path) + "'"));
    }

    private String flagsV1Uri(HttpRequest request) {
        URI uri = request.getUri();
        String port = uri.getPort() < 0 ? "" : ":" + uri.getPort();
        return uri.getScheme() + "://" + uri.getHost() + port + "/flags/v1";
    }

    private HttpResponse getDefinedFlag(FlagId flagId) {
        Optional<DefinedFlag> definedFlag = Flags.getFlag((FlagId)flagId).map(DefinedFlag::new);
        if (definedFlag.isPresent()) {
            return definedFlag.get();
        }
        return ErrorResponse.notFoundError((String)("Flag " + String.valueOf(flagId) + " not defined"));
    }

    private HttpResponse getFlagDataList(HttpRequest request) {
        return new FlagDataListResponse(this.flagsV1Uri(request), this.flagsDb.getAllFlagData(), Objects.equals(request.getProperty("recursive"), "true"));
    }

    private HttpResponse getFlagData(FlagId flagId) {
        Optional<FlagDataResponse> data = this.flagsDb.getValue(flagId).map(FlagDataResponse::new);
        if (data.isPresent()) {
            return data.get();
        }
        return ErrorResponse.notFoundError((String)("Flag " + String.valueOf(flagId) + " not set"));
    }

    private HttpResponse putFlagData(HttpRequest request, FlagId flagId) {
        FlagData data;
        try {
            data = FlagData.deserialize((InputStream)request.getData());
        }
        catch (UncheckedIOException e) {
            return ErrorResponse.badRequest((String)("Failed to deserialize request data: " + Exceptions.toMessageString((Throwable)e)));
        }
        if (!this.isForce(request)) {
            FlagDefinition definition = (FlagDefinition)Flags.getFlag((FlagId)flagId).get();
            data.validate((Deserializer)definition.getUnboundFlag().serializer());
        }
        this.flagsDb.setValue(flagId, data);
        return new OKResponse();
    }

    private HttpResponse deleteFlagData(FlagId flagId) {
        this.flagsDb.removeValue(flagId);
        return new OKResponse();
    }

    private FlagId findFlagId(HttpRequest request, Path path) {
        FlagId flagId = new FlagId(path.get("flagId"));
        if (!this.isForce(request) && Flags.getFlag((FlagId)flagId).isEmpty()) {
            throw new IllegalArgumentException("There is no flag '" + String.valueOf(flagId) + "' (use ?force=true to override)");
        }
        return flagId;
    }

    private boolean isForce(HttpRequest request) {
        return Objects.equals(request.getProperty("force"), "true");
    }
}

