/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.configserver.flags.http;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.json.Jackson;
import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.FlagDefinition;
import com.yahoo.vespa.flags.json.DimensionHelper;
import java.io.IOException;
import java.io.OutputStream;

public class DefinedFlag
extends HttpResponse {
    private static final ObjectMapper mapper = Jackson.mapper();
    private final FlagDefinition flagDefinition;

    public DefinedFlag(FlagDefinition flagDefinition) {
        super(200);
        this.flagDefinition = flagDefinition;
    }

    public void render(OutputStream outputStream) throws IOException {
        ObjectNode rootNode = mapper.createObjectNode();
        DefinedFlag.renderFlagDefinition(this.flagDefinition, rootNode);
        mapper.writeValue(outputStream, (Object)rootNode);
    }

    static void renderFlagDefinition(FlagDefinition flagDefinition, ObjectNode definitionNode) {
        definitionNode.put("description", flagDefinition.getDescription());
        definitionNode.put("modification-effect", flagDefinition.getModificationEffect());
        ArrayNode ownersNode = mapper.createArrayNode();
        flagDefinition.getOwners().forEach(arg_0 -> ((ArrayNode)ownersNode).add(arg_0));
        definitionNode.set("owners", (JsonNode)ownersNode);
        definitionNode.put("createdAt", flagDefinition.getCreatedAt().toString());
        definitionNode.put("expiresAt", flagDefinition.getExpiresAt().toString());
        ArrayNode dimensionsNode = definitionNode.putArray("dimensions");
        flagDefinition.getDimensions().forEach(dimension -> dimensionsNode.add(DimensionHelper.toWire((FetchVector.Dimension)dimension)));
    }

    public String getContentType() {
        return "application/json";
    }
}

