/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.configserver.flags.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.json.FlagData;
import com.yahoo.vespa.flags.json.wire.WireFlagDataList;
import com.yahoo.yolean.Exceptions;
import java.io.OutputStream;
import java.util.Map;
import java.util.TreeMap;

public class FlagDataListResponse
extends HttpResponse {
    private static ObjectMapper mapper = new ObjectMapper();
    private final String flagsV1Uri;
    private final TreeMap<FlagId, FlagData> flags;
    private final boolean recursive;

    public FlagDataListResponse(String flagsV1Uri, Map<FlagId, FlagData> flags, boolean recursive) {
        super(200);
        this.flagsV1Uri = flagsV1Uri;
        this.flags = new TreeMap<FlagId, FlagData>(flags);
        this.recursive = recursive;
    }

    public void render(OutputStream outputStream) {
        if (this.recursive) {
            WireFlagDataList list = new WireFlagDataList();
            this.flags.values().forEach(flagData -> list.flags.add(flagData.toWire()));
            list.serializeToOutputStream(outputStream);
        } else {
            ObjectNode rootNode = mapper.createObjectNode();
            ArrayNode flagsArray = rootNode.putArray("flags");
            this.flags.forEach((flagId, flagData) -> {
                ObjectNode object = flagsArray.addObject();
                object.put("id", flagId.toString());
                object.put("url", this.flagsV1Uri + "/data/" + flagId.toString());
            });
            Exceptions.uncheck(() -> mapper.writeValue(outputStream, (Object)rootNode));
        }
    }

    public String getContentType() {
        return "application/json";
    }
}

