/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.configserver.flags.db;

import com.google.inject.Inject;
import com.yahoo.path.Path;
import com.yahoo.vespa.configserver.flags.FlagsDb;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.json.FlagData;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class FlagsDbImpl
implements FlagsDb {
    private static final Path ROOT_PATH = Path.fromString((String)"/flags/v1");
    private final Curator curator;

    @Inject
    public FlagsDbImpl(Curator curator) {
        this.curator = curator;
    }

    @Override
    public Optional<FlagData> getValue(FlagId flagId) {
        return this.curator.getData(FlagsDbImpl.getZkPathFor(flagId)).map(FlagData::deserializeUtf8Json);
    }

    @Override
    public void setValue(FlagId flagId, FlagData data) {
        this.curator.set(FlagsDbImpl.getZkPathFor(flagId), data.serializeToUtf8Json());
    }

    @Override
    public Map<FlagId, FlagData> getAllFlags() {
        HashMap<FlagId, FlagData> flags = new HashMap<FlagId, FlagData>();
        for (String flagId : this.curator.getChildren(ROOT_PATH)) {
            FlagId id = new FlagId(flagId);
            this.getValue(id).ifPresent(data -> flags.put(id, (FlagData)data));
        }
        return flags;
    }

    @Override
    public void removeValue(FlagId flagId) {
        this.curator.delete(FlagsDbImpl.getZkPathFor(flagId));
    }

    private static Path getZkPathFor(FlagId flagId) {
        return ROOT_PATH.append(flagId.toString());
    }
}

