/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.content;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class StorDistributionConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "08289a63c28d780e984b32b3be7ca6d2";
    public static final String CONFIG_DEF_NAME = "stor-distribution";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.content";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.content", "redundancy int default=3", "initial_redundancy int default=0", "ensure_primary_persisted bool default=true", "ready_copies int default=0", "active_per_leaf_group bool default=false", "distributor_auto_ownership_transfer_on_whole_group_down bool default=true", "group[].index string", "group[].name string", "group[].capacity double default=1", "group[].partitions string default=\"\"", "group[].nodes[].index int", "group[].nodes[].retired bool default=false", "disk_distribution enum { MODULO, MODULO_INDEX, MODULO_KNUTH, MODULO_BID } default=MODULO_BID"};
    private final IntegerNode redundancy;
    private final IntegerNode initial_redundancy;
    private final BooleanNode ensure_primary_persisted;
    private final IntegerNode ready_copies;
    private final BooleanNode active_per_leaf_group;
    private final BooleanNode distributor_auto_ownership_transfer_on_whole_group_down;
    private final InnerNodeVector<Group> group;
    private final Disk_distribution disk_distribution;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public StorDistributionConfig(Builder builder) {
        this(builder, true);
    }

    private StorDistributionConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for stor-distribution must be initialized: " + builder.__uninitialized);
        }
        this.redundancy = builder.redundancy == null ? new IntegerNode(3) : new IntegerNode(builder.redundancy.intValue());
        this.initial_redundancy = builder.initial_redundancy == null ? new IntegerNode(0) : new IntegerNode(builder.initial_redundancy.intValue());
        this.ensure_primary_persisted = builder.ensure_primary_persisted == null ? new BooleanNode(true) : new BooleanNode(builder.ensure_primary_persisted.booleanValue());
        this.ready_copies = builder.ready_copies == null ? new IntegerNode(0) : new IntegerNode(builder.ready_copies.intValue());
        this.active_per_leaf_group = builder.active_per_leaf_group == null ? new BooleanNode(false) : new BooleanNode(builder.active_per_leaf_group.booleanValue());
        this.distributor_auto_ownership_transfer_on_whole_group_down = builder.distributor_auto_ownership_transfer_on_whole_group_down == null ? new BooleanNode(true) : new BooleanNode(builder.distributor_auto_ownership_transfer_on_whole_group_down.booleanValue());
        this.group = Group.createVector(builder.group);
        this.disk_distribution = builder.disk_distribution == null ? new Disk_distribution(Disk_distribution.MODULO_BID) : new Disk_distribution(builder.disk_distribution);
    }

    public int redundancy() {
        return this.redundancy.value();
    }

    public int initial_redundancy() {
        return this.initial_redundancy.value();
    }

    public boolean ensure_primary_persisted() {
        return this.ensure_primary_persisted.value();
    }

    public int ready_copies() {
        return this.ready_copies.value();
    }

    public boolean active_per_leaf_group() {
        return this.active_per_leaf_group.value();
    }

    public boolean distributor_auto_ownership_transfer_on_whole_group_down() {
        return this.distributor_auto_ownership_transfer_on_whole_group_down.value();
    }

    public List<Group> group() {
        return this.group;
    }

    public Group group(int i) {
        return (Group)((Object)this.group.get(i));
    }

    public Disk_distribution.Enum disk_distribution() {
        return (Disk_distribution.Enum)((Object)this.disk_distribution.value());
    }

    private ChangesRequiringRestart getChangesRequiringRestart(StorDistributionConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Disk_distribution
    extends EnumNode<Enum> {
        public static final Enum MODULO = Enum.MODULO;
        public static final Enum MODULO_INDEX = Enum.MODULO_INDEX;
        public static final Enum MODULO_KNUTH = Enum.MODULO_KNUTH;
        public static final Enum MODULO_BID = Enum.MODULO_BID;

        public Disk_distribution() {
            this.value = null;
        }

        public Disk_distribution(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(@NonNull String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            MODULO,
            MODULO_INDEX,
            MODULO_KNUTH,
            MODULO_BID;

        }
    }

    public static final class Group
    extends InnerNode {
        private final StringNode index;
        private final StringNode name;
        private final DoubleNode capacity;
        private final StringNode partitions;
        private final InnerNodeVector<Nodes> nodes;

        @Deprecated
        private Group() {
            this(new Builder(), false);
        }

        public Group(Builder builder) {
            this(builder, true);
        }

        private Group(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for stor-distribution.group[] must be initialized: " + builder.__uninitialized);
            }
            this.index = builder.index == null ? new StringNode() : new StringNode(builder.index);
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.capacity = builder.capacity == null ? new DoubleNode(1.0) : new DoubleNode(builder.capacity.doubleValue());
            this.partitions = builder.partitions == null ? new StringNode(StorDistributionConfig.CONFIG_DEF_VERSION) : new StringNode(builder.partitions);
            this.nodes = Nodes.createVector(builder.nodes);
        }

        public String index() {
            return this.index.value();
        }

        public String name() {
            return this.name.value();
        }

        public double capacity() {
            return this.capacity.value();
        }

        public String partitions() {
            return this.partitions.value();
        }

        public List<Nodes> nodes() {
            return this.nodes;
        }

        public Nodes nodes(int i) {
            return (Nodes)((Object)this.nodes.get(i));
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Group newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("group");
            return changes;
        }

        private static InnerNodeVector<Group> createVector(List<Builder> builders) {
            ArrayList<Group> elems = new ArrayList<Group>();
            for (Builder b : builders) {
                elems.add(new Group(b));
            }
            return new InnerNodeVector(elems, (InnerNode)new Group());
        }

        public static final class Nodes
        extends InnerNode {
            private final IntegerNode index;
            private final BooleanNode retired;

            @Deprecated
            private Nodes() {
                this(new Builder(), false);
            }

            public Nodes(Builder builder) {
                this(builder, true);
            }

            private Nodes(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for stor-distribution.group[].nodes[] must be initialized: " + builder.__uninitialized);
                }
                this.index = builder.index == null ? new IntegerNode() : new IntegerNode(builder.index.intValue());
                this.retired = builder.retired == null ? new BooleanNode(false) : new BooleanNode(builder.retired.booleanValue());
            }

            public int index() {
                return this.index.value();
            }

            public boolean retired() {
                return this.retired.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Nodes newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("nodes");
                return changes;
            }

            private static InnerNodeVector<Nodes> createVector(List<Builder> builders) {
                ArrayList<Nodes> elems = new ArrayList<Nodes>();
                for (Builder b : builders) {
                    elems.add(new Nodes(b));
                }
                return new InnerNodeVector(elems, (InnerNode)new Nodes());
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("index"));
                private Integer index = null;
                private Boolean retired = null;

                public Builder() {
                }

                public Builder(Nodes config) {
                    this.index(config.index());
                    this.retired(config.retired());
                }

                private Builder override(Builder __superior) {
                    if (__superior.index != null) {
                        this.index(__superior.index);
                    }
                    if (__superior.retired != null) {
                        this.retired(__superior.retired);
                    }
                    return this;
                }

                public Builder index(int __value) {
                    this.index = __value;
                    this.__uninitialized.remove("index");
                    return this;
                }

                private Builder index(String __value) {
                    return this.index(Integer.valueOf(__value));
                }

                public Builder retired(boolean __value) {
                    this.retired = __value;
                    return this;
                }

                private Builder retired(String __value) {
                    return this.retired(Boolean.valueOf(__value));
                }
            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("index", "name"));
            private String index = null;
            private String name = null;
            private Double capacity = null;
            private String partitions = null;
            public List<Nodes.Builder> nodes = new ArrayList<Nodes.Builder>();

            public Builder() {
            }

            public Builder(Group config) {
                this.index(config.index());
                this.name(config.name());
                this.capacity(config.capacity());
                this.partitions(config.partitions());
                for (Nodes n : config.nodes()) {
                    this.nodes(new Nodes.Builder(n));
                }
            }

            private Builder override(Builder __superior) {
                if (__superior.index != null) {
                    this.index(__superior.index);
                }
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.capacity != null) {
                    this.capacity(__superior.capacity);
                }
                if (__superior.partitions != null) {
                    this.partitions(__superior.partitions);
                }
                if (!__superior.nodes.isEmpty()) {
                    this.nodes.addAll(__superior.nodes);
                }
                return this;
            }

            public Builder index(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.index = __value;
                this.__uninitialized.remove("index");
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder capacity(double __value) {
                this.capacity = __value;
                return this;
            }

            private Builder capacity(String __value) {
                return this.capacity(Double.valueOf(__value));
            }

            public Builder partitions(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.partitions = __value;
                return this;
            }

            public Builder nodes(Nodes.Builder __builder) {
                this.nodes.add(__builder);
                return this;
            }

            public Builder nodes(List<Nodes.Builder> __builders) {
                this.nodes = __builders;
                return this;
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Integer redundancy = null;
        private Integer initial_redundancy = null;
        private Boolean ensure_primary_persisted = null;
        private Integer ready_copies = null;
        private Boolean active_per_leaf_group = null;
        private Boolean distributor_auto_ownership_transfer_on_whole_group_down = null;
        public List<Group.Builder> group = new ArrayList<Group.Builder>();
        private Disk_distribution.Enum disk_distribution = null;

        public Builder() {
        }

        public Builder(StorDistributionConfig config) {
            this.redundancy(config.redundancy());
            this.initial_redundancy(config.initial_redundancy());
            this.ensure_primary_persisted(config.ensure_primary_persisted());
            this.ready_copies(config.ready_copies());
            this.active_per_leaf_group(config.active_per_leaf_group());
            this.distributor_auto_ownership_transfer_on_whole_group_down(config.distributor_auto_ownership_transfer_on_whole_group_down());
            for (Group g : config.group()) {
                this.group(new Group.Builder(g));
            }
            this.disk_distribution(config.disk_distribution());
        }

        private Builder override(Builder __superior) {
            if (__superior.redundancy != null) {
                this.redundancy(__superior.redundancy);
            }
            if (__superior.initial_redundancy != null) {
                this.initial_redundancy(__superior.initial_redundancy);
            }
            if (__superior.ensure_primary_persisted != null) {
                this.ensure_primary_persisted(__superior.ensure_primary_persisted);
            }
            if (__superior.ready_copies != null) {
                this.ready_copies(__superior.ready_copies);
            }
            if (__superior.active_per_leaf_group != null) {
                this.active_per_leaf_group(__superior.active_per_leaf_group);
            }
            if (__superior.distributor_auto_ownership_transfer_on_whole_group_down != null) {
                this.distributor_auto_ownership_transfer_on_whole_group_down(__superior.distributor_auto_ownership_transfer_on_whole_group_down);
            }
            if (!__superior.group.isEmpty()) {
                this.group.addAll(__superior.group);
            }
            if (__superior.disk_distribution != null) {
                this.disk_distribution(__superior.disk_distribution);
            }
            return this;
        }

        public Builder redundancy(int __value) {
            this.redundancy = __value;
            return this;
        }

        private Builder redundancy(String __value) {
            return this.redundancy(Integer.valueOf(__value));
        }

        public Builder initial_redundancy(int __value) {
            this.initial_redundancy = __value;
            return this;
        }

        private Builder initial_redundancy(String __value) {
            return this.initial_redundancy(Integer.valueOf(__value));
        }

        public Builder ensure_primary_persisted(boolean __value) {
            this.ensure_primary_persisted = __value;
            return this;
        }

        private Builder ensure_primary_persisted(String __value) {
            return this.ensure_primary_persisted(Boolean.valueOf(__value));
        }

        public Builder ready_copies(int __value) {
            this.ready_copies = __value;
            return this;
        }

        private Builder ready_copies(String __value) {
            return this.ready_copies(Integer.valueOf(__value));
        }

        public Builder active_per_leaf_group(boolean __value) {
            this.active_per_leaf_group = __value;
            return this;
        }

        private Builder active_per_leaf_group(String __value) {
            return this.active_per_leaf_group(Boolean.valueOf(__value));
        }

        public Builder distributor_auto_ownership_transfer_on_whole_group_down(boolean __value) {
            this.distributor_auto_ownership_transfer_on_whole_group_down = __value;
            return this;
        }

        private Builder distributor_auto_ownership_transfer_on_whole_group_down(String __value) {
            return this.distributor_auto_ownership_transfer_on_whole_group_down(Boolean.valueOf(__value));
        }

        public Builder group(Group.Builder __builder) {
            this.group.add(__builder);
            return this;
        }

        public Builder group(List<Group.Builder> __builders) {
            this.group = __builders;
            return this;
        }

        public Builder disk_distribution(Disk_distribution.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.disk_distribution = __value;
            return this;
        }

        private Builder disk_distribution(String __value) {
            return this.disk_distribution(Disk_distribution.Enum.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return StorDistributionConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return StorDistributionConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return StorDistributionConfig.CONFIG_DEF_NAMESPACE;
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

