/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.cloud.config;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ModelConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "665f15b69fcddf6de75c32230ffdfc0e";
    public static final String CONFIG_DEF_NAME = "model";
    public static final String CONFIG_DEF_NAMESPACE = "cloud.config";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=cloud.config", "vespaVersion string default=\"unknown\"", "hosts[].name string default=\"(unknownhostname)\"", "hosts[].services[].name string default=\"(noservicename)\"", "hosts[].services[].type string default=\"(noservicetype)\"", "hosts[].services[].configid string default=\"(noconfigid)\"", "hosts[].services[].clustertype string default=\"(unknownclustertype)\"", "hosts[].services[].clustername string default=\"(unknownclustername)\"", "hosts[].services[].index int default=0", "hosts[].services[].ports[].number int default=-1", "hosts[].services[].ports[].tags string default=\"(notags)\""};
    private final StringNode vespaVersion;
    private final InnerNodeVector<Hosts> hosts;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public ModelConfig(Builder builder) {
        this(builder, true);
    }

    private ModelConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for model must be initialized: " + builder.__uninitialized);
        }
        this.vespaVersion = builder.vespaVersion == null ? new StringNode("unknown") : new StringNode(builder.vespaVersion);
        this.hosts = Hosts.createVector(builder.hosts);
    }

    public String vespaVersion() {
        return this.vespaVersion.value();
    }

    public List<Hosts> hosts() {
        return this.hosts;
    }

    public Hosts hosts(int i) {
        return (Hosts)((Object)this.hosts.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(ModelConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Hosts
    extends InnerNode {
        private final StringNode name;
        private final InnerNodeVector<Services> services;

        @Deprecated
        private Hosts() {
            this(new Builder(), false);
        }

        public Hosts(Builder builder) {
            this(builder, true);
        }

        private Hosts(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for model.hosts[] must be initialized: " + builder.__uninitialized);
            }
            this.name = builder.name == null ? new StringNode("(unknownhostname)") : new StringNode(builder.name);
            this.services = Services.createVector(builder.services);
        }

        public String name() {
            return this.name.value();
        }

        public List<Services> services() {
            return this.services;
        }

        public Services services(int i) {
            return (Services)((Object)this.services.get(i));
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Hosts newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("hosts");
            return changes;
        }

        private static InnerNodeVector<Hosts> createVector(List<Builder> builders) {
            ArrayList<Hosts> elems = new ArrayList<Hosts>();
            for (Builder b : builders) {
                elems.add(new Hosts(b));
            }
            return new InnerNodeVector(elems, (InnerNode)new Hosts());
        }

        public static final class Services
        extends InnerNode {
            private final StringNode name;
            private final StringNode type;
            private final StringNode configid;
            private final StringNode clustertype;
            private final StringNode clustername;
            private final IntegerNode index;
            private final InnerNodeVector<Ports> ports;

            @Deprecated
            private Services() {
                this(new Builder(), false);
            }

            public Services(Builder builder) {
                this(builder, true);
            }

            private Services(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for model.hosts[].services[] must be initialized: " + builder.__uninitialized);
                }
                this.name = builder.name == null ? new StringNode("(noservicename)") : new StringNode(builder.name);
                this.type = builder.type == null ? new StringNode("(noservicetype)") : new StringNode(builder.type);
                this.configid = builder.configid == null ? new StringNode("(noconfigid)") : new StringNode(builder.configid);
                this.clustertype = builder.clustertype == null ? new StringNode("(unknownclustertype)") : new StringNode(builder.clustertype);
                this.clustername = builder.clustername == null ? new StringNode("(unknownclustername)") : new StringNode(builder.clustername);
                this.index = builder.index == null ? new IntegerNode(0) : new IntegerNode(builder.index.intValue());
                this.ports = Ports.createVector(builder.ports);
            }

            public String name() {
                return this.name.value();
            }

            public String type() {
                return this.type.value();
            }

            public String configid() {
                return this.configid.value();
            }

            public String clustertype() {
                return this.clustertype.value();
            }

            public String clustername() {
                return this.clustername.value();
            }

            public int index() {
                return this.index.value();
            }

            public List<Ports> ports() {
                return this.ports;
            }

            public Ports ports(int i) {
                return (Ports)((Object)this.ports.get(i));
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Services newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("services");
                return changes;
            }

            private static InnerNodeVector<Services> createVector(List<Builder> builders) {
                ArrayList<Services> elems = new ArrayList<Services>();
                for (Builder b : builders) {
                    elems.add(new Services(b));
                }
                return new InnerNodeVector(elems, (InnerNode)new Services());
            }

            public static final class Ports
            extends InnerNode {
                private final IntegerNode number;
                private final StringNode tags;

                @Deprecated
                private Ports() {
                    this(new Builder(), false);
                }

                public Ports(Builder builder) {
                    this(builder, true);
                }

                private Ports(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for model.hosts[].services[].ports[] must be initialized: " + builder.__uninitialized);
                    }
                    this.number = builder.number == null ? new IntegerNode(-1) : new IntegerNode(builder.number.intValue());
                    this.tags = builder.tags == null ? new StringNode("(notags)") : new StringNode(builder.tags);
                }

                public int number() {
                    return this.number.value();
                }

                public String tags() {
                    return this.tags.value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Ports newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("ports");
                    return changes;
                }

                private static InnerNodeVector<Ports> createVector(List<Builder> builders) {
                    ArrayList<Ports> elems = new ArrayList<Ports>();
                    for (Builder b : builders) {
                        elems.add(new Ports(b));
                    }
                    return new InnerNodeVector(elems, (InnerNode)new Ports());
                }

                public static class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>();
                    private Integer number = null;
                    private String tags = null;

                    public Builder() {
                    }

                    public Builder(Ports config) {
                        this.number(config.number());
                        this.tags(config.tags());
                    }

                    private Builder override(Builder __superior) {
                        if (__superior.number != null) {
                            this.number(__superior.number);
                        }
                        if (__superior.tags != null) {
                            this.tags(__superior.tags);
                        }
                        return this;
                    }

                    public Builder number(int __value) {
                        this.number = __value;
                        return this;
                    }

                    private Builder number(String __value) {
                        return this.number(Integer.valueOf(__value));
                    }

                    public Builder tags(String __value) {
                        if (__value == null) {
                            throw new IllegalArgumentException("Null value is not allowed.");
                        }
                        this.tags = __value;
                        return this;
                    }
                }
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private String name = null;
                private String type = null;
                private String configid = null;
                private String clustertype = null;
                private String clustername = null;
                private Integer index = null;
                public List<Ports.Builder> ports = new ArrayList<Ports.Builder>();

                public Builder() {
                }

                public Builder(Services config) {
                    this.name(config.name());
                    this.type(config.type());
                    this.configid(config.configid());
                    this.clustertype(config.clustertype());
                    this.clustername(config.clustername());
                    this.index(config.index());
                    for (Ports p : config.ports()) {
                        this.ports(new Ports.Builder(p));
                    }
                }

                private Builder override(Builder __superior) {
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    if (__superior.type != null) {
                        this.type(__superior.type);
                    }
                    if (__superior.configid != null) {
                        this.configid(__superior.configid);
                    }
                    if (__superior.clustertype != null) {
                        this.clustertype(__superior.clustertype);
                    }
                    if (__superior.clustername != null) {
                        this.clustername(__superior.clustername);
                    }
                    if (__superior.index != null) {
                        this.index(__superior.index);
                    }
                    if (!__superior.ports.isEmpty()) {
                        this.ports.addAll(__superior.ports);
                    }
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    return this;
                }

                public Builder type(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.type = __value;
                    return this;
                }

                public Builder configid(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.configid = __value;
                    return this;
                }

                public Builder clustertype(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.clustertype = __value;
                    return this;
                }

                public Builder clustername(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.clustername = __value;
                    return this;
                }

                public Builder index(int __value) {
                    this.index = __value;
                    return this;
                }

                private Builder index(String __value) {
                    return this.index(Integer.valueOf(__value));
                }

                public Builder ports(Ports.Builder __builder) {
                    this.ports.add(__builder);
                    return this;
                }

                public Builder ports(List<Ports.Builder> __builders) {
                    this.ports = __builders;
                    return this;
                }
            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private String name = null;
            public List<Services.Builder> services = new ArrayList<Services.Builder>();

            public Builder() {
            }

            public Builder(Hosts config) {
                this.name(config.name());
                for (Services s : config.services()) {
                    this.services(new Services.Builder(s));
                }
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (!__superior.services.isEmpty()) {
                    this.services.addAll(__superior.services);
                }
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                return this;
            }

            public Builder services(Services.Builder __builder) {
                this.services.add(__builder);
                return this;
            }

            public Builder services(List<Services.Builder> __builders) {
                this.services = __builders;
                return this;
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private String vespaVersion = null;
        public List<Hosts.Builder> hosts = new ArrayList<Hosts.Builder>();

        public Builder() {
        }

        public Builder(ModelConfig config) {
            this.vespaVersion(config.vespaVersion());
            for (Hosts h : config.hosts()) {
                this.hosts(new Hosts.Builder(h));
            }
        }

        private Builder override(Builder __superior) {
            if (__superior.vespaVersion != null) {
                this.vespaVersion(__superior.vespaVersion);
            }
            if (!__superior.hosts.isEmpty()) {
                this.hosts.addAll(__superior.hosts);
            }
            return this;
        }

        public Builder vespaVersion(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.vespaVersion = __value;
            return this;
        }

        public Builder hosts(Hosts.Builder __builder) {
            this.hosts.add(__builder);
            return this;
        }

        public Builder hosts(List<Hosts.Builder> __builders) {
            this.hosts = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return ModelConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return ModelConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return ModelConfig.CONFIG_DEF_NAMESPACE;
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

