/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.protocol;

import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.JsonFormat;
import com.yahoo.slime.Slime;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.config.protocol.SlimeTraceDeserializer;
import com.yahoo.vespa.config.protocol.SlimeTraceSerializer;
import com.yahoo.yolean.trace.TraceNode;
import com.yahoo.yolean.trace.TraceVisitor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Clock;

public class Trace {
    private static final String TRACE_TRACELOG = "traceLog";
    private static final String TRACE_TRACELEVEL = "traceLevel";
    private final int traceLevel;
    private final TraceNode traceNode;
    private final Clock clock;
    private static final int systemTraceLevel = Integer.getInteger("config.protocol.traceLevel", 0);

    private Trace(int traceLevel, TraceNode traceNode, Clock clock) {
        this.traceLevel = traceLevel;
        this.traceNode = traceNode;
        this.clock = clock;
    }

    public void trace(int level, String message) {
        if (this.shouldTrace(level)) {
            this.addTrace(message);
        }
    }

    private void addTrace(String message) {
        this.traceNode.add(new TraceNode((Object)message, this.clock.millis()));
    }

    public static Trace createNew(int traceLevel, Clock clock) {
        return new Trace(traceLevel, new TraceNode(null, clock.millis()), clock);
    }

    public static Trace createNew(int traceLevel) {
        return Trace.createNew(traceLevel, Clock.systemUTC());
    }

    public static Trace fromSlime(Inspector inspector) {
        int traceLevel = Trace.deserializeTraceLevel(inspector);
        Clock clock = Clock.systemUTC();
        SlimeTraceDeserializer deserializer = new SlimeTraceDeserializer(inspector.field(TRACE_TRACELOG));
        return new Trace(traceLevel, deserializer.deserialize(), clock);
    }

    private static int deserializeTraceLevel(Inspector inspector) {
        return (int)inspector.field(TRACE_TRACELEVEL).asLong();
    }

    public void serialize(Cursor cursor) {
        cursor.setLong(TRACE_TRACELEVEL, (long)this.traceLevel);
        SlimeTraceSerializer serializer = new SlimeTraceSerializer(cursor.setObject(TRACE_TRACELOG));
        this.traceNode.accept((TraceVisitor)serializer);
    }

    public static Trace createDummy() {
        return Trace.createNew(0);
    }

    public int getTraceLevel() {
        return this.traceLevel;
    }

    public boolean shouldTrace(int level) {
        return level <= this.traceLevel;
    }

    public String toString(boolean compact) {
        Slime slime = new Slime();
        this.serialize(slime.setObject());
        JsonFormat format = new JsonFormat(compact);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            format.encode((OutputStream)baos, slime);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to encode trace as JSON", e);
        }
        return Utf8.toString((byte[])baos.toByteArray());
    }

    public String toString() {
        return this.toString(false);
    }

    public static Trace createNew() {
        return Trace.createNew(systemTraceLevel);
    }
}

