/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.ConfigurationRuntimeException;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;

public class ConfigKey<CONFIGCLASS extends ConfigInstance>
implements Comparable<ConfigKey<?>> {
    @NonNull
    private final String name;
    @NonNull
    private final String configId;
    @NonNull
    private final String namespace;
    private final Class<CONFIGCLASS> configClass;
    private final String md5;

    public ConfigKey(String name, String configIdString, String namespace) {
        this(name, configIdString, namespace, null, null);
    }

    public ConfigKey(Class<CONFIGCLASS> clazz, String configIdString) {
        this(ConfigKey.getFieldFromClass(clazz, "CONFIG_DEF_NAME"), configIdString, ConfigKey.getFieldFromClass(clazz, "CONFIG_DEF_NAMESPACE"), ConfigKey.getFieldFromClass(clazz, "CONFIG_DEF_MD5"), clazz);
    }

    public ConfigKey(String name, String configIdString, String namespace, String defMd5, Class<CONFIGCLASS> clazz) {
        if (name == null) {
            throw new ConfigurationRuntimeException("Config name must be non-null!");
        }
        this.name = name;
        this.configId = configIdString == null ? "" : configIdString;
        this.namespace = namespace == null ? "config" : namespace;
        this.md5 = defMd5 == null ? "" : defMd5;
        this.configClass = clazz;
    }

    @Override
    public int compareTo(ConfigKey<?> o) {
        if (!o.getNamespace().equals(this.getNamespace())) {
            return this.getNamespace().compareTo(o.getNamespace());
        }
        if (!o.getName().equals(this.getName())) {
            return this.getName().compareTo(o.getName());
        }
        return this.getConfigId().compareTo(o.getConfigId());
    }

    private static String getFieldFromClass(Class<?> clazz, String fieldName) {
        try {
            return (String)clazz.getField(fieldName).get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ConfigurationRuntimeException("No such field '" + fieldName + "' in class " + clazz + ", or could not access field.", (Throwable)e);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigKey)) {
            return false;
        }
        ConfigKey key = (ConfigKey)o;
        return this.name.equals(key.name) && this.configId.equals(key.configId) && this.namespace.equals(key.namespace);
    }

    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + this.name.hashCode();
        hash = 37 * hash + this.configId.hashCode();
        hash = 37 * hash + this.namespace.hashCode();
        return hash;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getConfigId() {
        return this.configId;
    }

    @NonNull
    public String getNamespace() {
        return this.namespace;
    }

    @Nullable
    public Class<CONFIGCLASS> getConfigClass() {
        return this.configClass;
    }

    @Nullable
    public String getMd5() {
        return this.md5;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("name=");
        sb.append(this.name);
        sb.append(",namespace=");
        sb.append(this.namespace);
        sb.append(",configId=");
        sb.append(this.configId);
        return sb.toString();
    }

    public static ConfigKey<?> createFull(String name, String configId, String namespace, String md5) {
        return new ConfigKey(name, configId, namespace, md5, null);
    }
}

