/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription.impl;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.subscription.ConfigSource;
import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.config.subscription.impl.JRTConfigSubscription;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.RawConfig;
import com.yahoo.vespa.config.TimingValues;
import com.yahoo.vespa.config.protocol.DefContent;
import com.yahoo.vespa.config.protocol.JRTClientConfigRequest;
import java.util.List;
import java.util.logging.Level;

public class GenericJRTConfigSubscription
extends JRTConfigSubscription {
    private RawConfig config;
    private final List<String> defContent;

    public GenericJRTConfigSubscription(ConfigKey<?> key, List<String> defContent, ConfigSubscriber subscriber, ConfigSource source, TimingValues timingValues) {
        super(key, subscriber, source, timingValues);
        this.defContent = defContent;
    }

    @Override
    protected void setNewConfig(JRTClientConfigRequest jrtReq) {
        this.config = RawConfig.createFromResponseParameters(jrtReq);
        if (log.isLoggable((Level)LogLevel.DEBUG)) {
            log.log((Level)LogLevel.DEBUG, "in setNewConfig, config=" + this.config);
        }
    }

    @Override
    void setGeneration(Long generation) {
        super.setGeneration(generation);
        if (this.config != null) {
            this.config.setGeneration(generation);
        }
    }

    public RawConfig getRawConfig() {
        return this.config;
    }

    @Override
    public DefContent getDefContent() {
        return DefContent.fromList(this.defContent);
    }

    @Override
    public ConfigInstance getConfig() {
        return null;
    }
}

