/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription.impl;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.ConfigurationRuntimeException;
import com.yahoo.config.subscription.CfgConfigPayloadBuilder;
import com.yahoo.config.subscription.ConfigInterruptedException;
import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.config.subscription.impl.ConfigSubscription;
import com.yahoo.io.IOUtils;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.ConfigPayload;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;

public class FileConfigSubscription<T extends ConfigInstance>
extends ConfigSubscription<T> {
    final File file;
    long ts;

    FileConfigSubscription(ConfigKey<T> key, ConfigSubscriber subscriber, File f) {
        super(key, subscriber);
        this.setGeneration(0L);
        this.file = f;
        if (!this.file.exists() && !this.file.isFile()) {
            throw new IllegalArgumentException("Not a file: " + this.file);
        }
    }

    @Override
    public boolean nextConfig(long timeout) {
        if (!this.file.exists() && !this.file.isFile()) {
            throw new IllegalArgumentException("Not a file: " + this.file);
        }
        if (this.checkReloaded()) {
            log.log((Level)LogLevel.DEBUG, "User forced config reload at " + System.currentTimeMillis());
            this.updateConfig();
            log.log((Level)LogLevel.DEBUG, "Config updated at " + System.currentTimeMillis() + ", changed: " + this.isConfigChanged());
            log.log((Level)LogLevel.DEBUG, "Config: " + this.config.toString());
            return true;
        }
        if (this.file.lastModified() != this.ts) {
            this.updateConfig();
            Long l = this.generation;
            Long l2 = this.generation = Long.valueOf(this.generation + 1L);
            this.setGenerationChanged(true);
            return true;
        }
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException e) {
            throw new ConfigInterruptedException(e);
        }
        this.setGenerationChanged(false);
        this.setConfigChanged(false);
        return false;
    }

    private void updateConfig() {
        this.ts = this.file.lastModified();
        ConfigInstance prev = this.config;
        try {
            ConfigPayload payload = new CfgConfigPayloadBuilder().deserialize(Arrays.asList(IOUtils.readFile((File)this.file).split("\n")));
            this.config = payload.toInstance(this.configClass, this.key.getConfigId());
        }
        catch (IOException e) {
            throw new ConfigurationRuntimeException((Throwable)e);
        }
        this.setConfigChanged(!this.config.equals((Object)prev));
    }

    @Override
    public boolean subscribe(long timeout) {
        return true;
    }
}

