/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy;

import com.yahoo.vespa.config.ConfigCacheKey;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.RawConfig;
import com.yahoo.vespa.config.protocol.JRTServerConfigRequest;
import com.yahoo.vespa.config.proxy.ConfigSourceClient;
import com.yahoo.vespa.config.proxy.DelayedResponses;
import com.yahoo.vespa.config.proxy.MemoryCache;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

class MemoryCacheConfigClient
implements ConfigSourceClient {
    private static final Logger log = Logger.getLogger(MemoryCacheConfigClient.class.getName());
    private final MemoryCache cache;
    private final DelayedResponses delayedResponses = new DelayedResponses();

    MemoryCacheConfigClient(MemoryCache cache) {
        this.cache = cache;
    }

    @Override
    public Optional<RawConfig> getConfig(RawConfig input, JRTServerConfigRequest request) {
        ConfigKey key = input.getKey();
        Optional<RawConfig> cached = this.cache.get(new ConfigCacheKey(key, input.getDefMd5()));
        if (cached.isPresent()) {
            log.log(Level.FINE, () -> "Found config " + String.valueOf(key) + " in cache");
        }
        return cached;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void shutdownSourceConnections() {
    }

    @Override
    public String getActiveSourceConnection() {
        return "N/A";
    }

    @Override
    public List<String> getSourceConnections() {
        return List.of("N/A");
    }

    @Override
    public DelayedResponses delayedResponses() {
        return this.delayedResponses;
    }

    @Override
    public MemoryCache memoryCache() {
        return this.cache;
    }
}

