/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy.filedistribution;

import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.jrt.Method;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Value;
import com.yahoo.security.tls.Capability;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.config.proxy.filedistribution.DownloadOptions;
import com.yahoo.vespa.config.proxy.filedistribution.UrlDownloader;
import com.yahoo.vespa.config.util.ConfigUtils;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.yolean.Exceptions;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

class UrlDownloadRpcServer {
    private static final Logger log = Logger.getLogger(UrlDownloadRpcServer.class.getName());
    static final File defaultDownloadDirectory = new File(Defaults.getDefaults().underVespaHome("var/db/vespa/download"));
    private final File rootDownloadDir;
    private final ExecutorService executor = Executors.newFixedThreadPool(Math.max(8, Runtime.getRuntime().availableProcessors()), (ThreadFactory)new DaemonThreadFactory("Rpc URL download executor"));

    UrlDownloadRpcServer(Supervisor supervisor) {
        this.rootDownloadDir = defaultDownloadDirectory;
        supervisor.addMethod(new Method("url.waitFor", "s*", "s", this::download).requireCapabilities(new Capability[]{Capability.CONFIGPROXY__FILEDISTRIBUTION_API}).methodDesc("get path to url download").paramDesc(0, "url", "url").paramDesc(1, "auth_token", "auth token (optional)").returnDesc(0, "path", "path to file"));
    }

    void close() {
        this.executor.shutdownNow();
        try {
            if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                log.log(Level.WARNING, "Failed to shut down url download rpc server within timeout");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void download(Request req) {
        req.detach();
        this.executor.execute(() -> this.downloadFile(req));
    }

    private void downloadFile(Request req) {
        UrlDownloader downloader;
        String url = req.parameters().get(0).asString();
        String authHeader = req.parameters().size() > 1 ? req.parameters().get(1).asString() : null;
        File downloadDir = new File(this.rootDownloadDir, UrlDownloadRpcServer.urlToDirName(url));
        try {
            downloader = UrlDownloadRpcServer.downloader(url, new DownloadOptions(authHeader));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        if (downloader.alreadyDownloaded(downloadDir)) {
            log.log(Level.INFO, "URL '" + url + "' already downloaded");
            req.returnValues().add((Value)new StringValue(new File(downloadDir, downloader.fileName()).getAbsolutePath()));
            req.returnRequest();
            return;
        }
        try {
            Files.createDirectories(downloadDir.toPath(), new FileAttribute[0]);
            Optional<File> file = downloader.download(downloadDir);
            if (file.isPresent()) {
                req.returnValues().add((Value)new StringValue(file.get().getAbsolutePath()));
            } else {
                req.setError(65537, "URL '" + url + "' not found");
            }
        }
        catch (RuntimeException e) {
            UrlDownloadRpcServer.logAndSetRpcError(req, url, e, 65539);
        }
        catch (Throwable e) {
            UrlDownloadRpcServer.logAndSetRpcError(req, url, e, 65538);
        }
        req.returnRequest();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static UrlDownloader downloader(String urlString, DownloadOptions options) throws MalformedURLException {
        String scheme;
        Objects.requireNonNull(urlString, "url cannot be null");
        URI uri = URI.create(urlString);
        switch (scheme = uri.getScheme()) {
            case "http": 
            case "https": {
                return new UrlDownloader(uri, options);
            }
            default: {
                throw new IllegalArgumentException("Unsupported scheme '" + scheme + "'");
            }
        }
    }

    private static void logAndSetRpcError(Request req, String url, Throwable e, int rpcErrorCode) {
        String message = "Download of '" + url + "' failed: " + Exceptions.toMessageString((Throwable)e);
        log.log(Level.SEVERE, message);
        req.setError(rpcErrorCode, e.getMessage());
    }

    private static String urlToDirName(String uri) {
        return ConfigUtils.getXxhash64((ByteBuffer)ByteBuffer.wrap(Utf8.toBytes((String)uri)));
    }
}

