/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy.filedistribution;

import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.io.IOUtils;
import com.yahoo.vespa.config.proxy.filedistribution.UrlDownloadRpcServer;
import com.yahoo.vespa.config.util.ConfigUtils;
import com.yahoo.vespa.filedistribution.FileDownloader;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.time.Instant;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

class FileReferencesAndDownloadsMaintainer
implements Runnable {
    private static final Logger log = Logger.getLogger(FileReferencesAndDownloadsMaintainer.class.getName());
    private static final File defaultUrlDownloadDir = UrlDownloadRpcServer.defaultDownloadDirectory;
    private static final File defaultFileReferencesDownloadDir = FileDownloader.defaultDownloadDirectory;
    private static final Duration defaultDurationToKeepFiles = Duration.ofDays(30L);
    private static final int defaultOutdatedFilesToKeep = 20;
    private static final Duration interval = Duration.ofMinutes(1L);
    private final Optional<ScheduledExecutorService> executor;
    private final File urlDownloadDir;
    private final File fileReferencesDownloadDir;
    private final Duration durationToKeepFiles;
    private final int outDatedFilesToKeep;

    FileReferencesAndDownloadsMaintainer() {
        this(defaultFileReferencesDownloadDir, defaultUrlDownloadDir, FileReferencesAndDownloadsMaintainer.keepFileReferencesDuration(), FileReferencesAndDownloadsMaintainer.outDatedFilesToKeep(), FileReferencesAndDownloadsMaintainer.configServers());
    }

    FileReferencesAndDownloadsMaintainer(File fileReferencesDownloadDir, File urlDownloadDir, Duration durationToKeepFiles, int outdatedFilesToKeep, List<String> configServers) {
        this.fileReferencesDownloadDir = fileReferencesDownloadDir;
        this.urlDownloadDir = urlDownloadDir;
        this.durationToKeepFiles = durationToKeepFiles;
        this.outDatedFilesToKeep = outdatedFilesToKeep;
        if (configServers.contains(ConfigUtils.getCanonicalHostName())) {
            log.log(Level.INFO, "Not running maintainer, since this is on a config server host");
            this.executor = Optional.empty();
        } else {
            this.executor = Optional.of(new ScheduledThreadPoolExecutor(1, (ThreadFactory)new DaemonThreadFactory("file references and downloads cleanup")));
            this.executor.get().scheduleAtFixedRate(this, interval.toSeconds(), interval.toSeconds(), TimeUnit.SECONDS);
        }
    }

    @Override
    public void run() {
        if (this.executor.isEmpty()) {
            return;
        }
        try {
            this.deleteUnusedFiles(this.fileReferencesDownloadDir);
            this.deleteUnusedFiles(this.urlDownloadDir);
        }
        catch (Throwable t) {
            log.log(Level.WARNING, "Deleting unused files failed. ", t);
        }
    }

    public void close() {
        this.executor.ifPresent(ex -> {
            ex.shutdownNow();
            try {
                if (!ex.awaitTermination(10L, TimeUnit.SECONDS)) {
                    throw new RuntimeException("Unable to shutdown " + String.valueOf(this.executor) + " before timeout");
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void deleteUnusedFiles(File directory) {
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        List<File> filesToDelete = this.filesThatCanBeDeleted(files);
        filesToDelete.forEach(fileReference -> {
            if (IOUtils.recursiveDeleteDir((File)fileReference)) {
                log.log(Level.FINE, "Deleted " + fileReference.getAbsolutePath());
            } else {
                log.log(Level.WARNING, "Could not delete " + fileReference.getAbsolutePath());
            }
        });
    }

    private List<File> filesThatCanBeDeleted(File[] files) {
        Instant deleteNotUsedSinceInstant = Instant.now().minus(this.durationToKeepFiles);
        HashSet<File> filesOnDisk = new HashSet<File>(List.of(files));
        log.log(Level.FINE, () -> "Files on disk: " + String.valueOf(filesOnDisk));
        int deleteCount = Math.max(0, filesOnDisk.size() - this.outDatedFilesToKeep);
        List<File> canBeDeleted = filesOnDisk.stream().peek(file -> log.log(Level.FINE, () -> String.valueOf(file) + ":" + String.valueOf(FileReferencesAndDownloadsMaintainer.fileLastModifiedTime(file.toPath())))).filter(fileReference -> this.isFileLastModifiedBefore((File)fileReference, deleteNotUsedSinceInstant)).sorted(Comparator.comparing(fileReference -> FileReferencesAndDownloadsMaintainer.fileLastModifiedTime(fileReference.toPath()))).toList();
        canBeDeleted = canBeDeleted.subList(0, Math.min(canBeDeleted.size(), deleteCount));
        if (canBeDeleted.size() > 0) {
            log.log(Level.INFO, "Files that can be deleted (not accessed since " + String.valueOf(deleteNotUsedSinceInstant) + ", will also keep " + this.outDatedFilesToKeep + " no matter when last accessed): " + String.valueOf(canBeDeleted));
        }
        return canBeDeleted;
    }

    private boolean isFileLastModifiedBefore(File fileReference, Instant instant) {
        return FileReferencesAndDownloadsMaintainer.fileLastModifiedTime(fileReference.toPath()).isBefore(instant);
    }

    private static Instant fileLastModifiedTime(Path fileReference) {
        try {
            BasicFileAttributes fileAttributes = Files.readAttributes(fileReference, BasicFileAttributes.class, new LinkOption[0]);
            return fileAttributes.lastModifiedTime().toInstant();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Duration keepFileReferencesDuration() {
        String env = System.getenv("VESPA_KEEP_FILE_REFERENCES_DAYS");
        if (env != null && !env.isEmpty()) {
            return Duration.ofDays(Integer.parseInt(env));
        }
        return defaultDurationToKeepFiles;
    }

    private static int outDatedFilesToKeep() {
        String env = System.getenv("VESPA_KEEP_FILE_REFERENCES_COUNT");
        if (env != null && !env.isEmpty()) {
            return Integer.parseInt(env);
        }
        return 20;
    }

    private static List<String> configServers() {
        String env = System.getenv("VESPA_CONFIGSERVERS");
        if (env == null || env.isEmpty()) {
            return List.of(ConfigUtils.getCanonicalHostName());
        }
        return List.of(env.split(","));
    }
}

