/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy.filedistribution;

import com.yahoo.vespa.config.proxy.filedistribution.Downloader;
import com.yahoo.vespa.config.proxy.filedistribution.RequestTracker;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

class UrlDownloader
implements Downloader {
    private static final Logger log = Logger.getLogger(UrlDownloader.class.getName());
    private static final String CONTENTS_FILE_NAME = "contents";
    private static final String USER_AGENT_MODEL_DOWNLOADER = "Vespa/8.x (model download - https://github.com/vespa-engine/vespa)";

    UrlDownloader() {
    }

    @Override
    public Optional<File> downloadFile(String url, File downloadDir) throws IOException {
        long start = System.currentTimeMillis();
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestProperty("User-Agent", USER_AGENT_MODEL_DOWNLOADER);
        if (connection.getResponseCode() != 200) {
            throw new RuntimeException("Download of URL '" + url + "' failed, got response code " + connection.getResponseCode());
        }
        log.log(Level.INFO, "Downloading URL '" + url + "'");
        File contentsPath = new File(downloadDir, CONTENTS_FILE_NAME);
        try (ReadableByteChannel rbc = Channels.newChannel(connection.getInputStream());){
            FileOutputStream fos;
            block14: {
                Optional<File> optional;
                fos = new FileOutputStream(contentsPath.getAbsolutePath());
                try {
                    fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                    if (!contentsPath.exists() || contentsPath.length() <= 0L) break block14;
                    new RequestTracker().trackRequest(downloadDir);
                    log.log(Level.FINE, () -> "URL '" + url + "' available at " + contentsPath);
                    log.log(Level.INFO, String.format("Download of URL '%s' done in %.3f seconds", url, (double)(System.currentTimeMillis() - start) / 1000.0));
                    optional = Optional.of(contentsPath);
                }
                catch (Throwable throwable) {
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                fos.close();
                return optional;
            }
            log.log(Level.SEVERE, "Downloaded URL '" + url + "' not found, returning error");
            Optional<File> optional = Optional.empty();
            fos.close();
            return optional;
        }
    }
}

