/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy;

import ai.vespa.util.http.hc5.VespaHttpClientBuilder;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.BasicHttpClientResponseHandler;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;

public class ConfigVerification {
    private static final int port = 19071;
    private static final String prefix = "http://";

    public static void main(String[] args) throws IOException {
        ArrayList<String> configservers = new ArrayList<String>();
        String tenant = "default";
        String appName = "default";
        String environment = "prod";
        String region = "default";
        String instance = "default";
        for (String arg : args) {
            configservers.add(prefix + arg + ":19071/config/v2/tenant/" + tenant + "/application/" + appName + "/environment/" + environment + "/region/" + region + "/instance/" + instance + "/?recursive=true");
        }
        try (CloseableHttpClient httpClient = VespaHttpClientBuilder.custom().buildClient();){
            System.exit(ConfigVerification.compareConfigs(ConfigVerification.listConfigs(configservers, httpClient), httpClient));
        }
    }

    private static Map<String, Deque<String>> listConfigs(List<String> urls, CloseableHttpClient httpClient) throws IOException {
        Map<String, String> outputs = ConfigVerification.performRequests(urls, httpClient);
        LinkedHashMap<String, Deque<String>> recurseMappings = new LinkedHashMap<String, Deque<String>>();
        for (Map.Entry<String, String> entry : outputs.entrySet()) {
            Slime slime = SlimeUtils.jsonToSlime((String)entry.getValue());
            ArrayList list = new ArrayList();
            slime.get().field("configs").traverse((idx, inspector) -> list.add(inspector.asString()));
            Collections.sort(list);
            ArrayDeque stack = new ArrayDeque(list);
            recurseMappings.put(entry.getKey(), stack);
        }
        return recurseMappings;
    }

    private static Map<String, String> performRequests(List<String> urls, CloseableHttpClient httpClient) throws IOException {
        LinkedHashMap<String, String> outputs = new LinkedHashMap<String, String>();
        for (String url : urls) {
            outputs.put(url, ConfigVerification.performRequest(url, httpClient));
        }
        return outputs;
    }

    private static int compareConfigs(Map<String, Deque<String>> mappings, CloseableHttpClient httpClient) throws IOException {
        for (int n = 0; n < mappings.values().iterator().next().size(); ++n) {
            ArrayList<String> recurseUrls = new ArrayList<String>();
            for (Map.Entry<String, Deque<String>> entry : mappings.entrySet()) {
                recurseUrls.add(entry.getValue().pop());
            }
            if (ConfigVerification.equalOutputs(ConfigVerification.performRequests(recurseUrls, httpClient))) continue;
            return -1;
        }
        return 0;
    }

    private static boolean equalOutputs(Map<String, String> outputs) {
        Map.Entry<String, String> firstEntry = outputs.entrySet().iterator().next();
        for (Map.Entry<String, String> entry : outputs.entrySet()) {
            if (entry.getValue().equals(firstEntry.getValue())) continue;
            System.out.println("output from '" + entry.getKey() + "': '" + entry.getValue() + "' did not equal output from '" + firstEntry.getKey() + "': '" + firstEntry.getValue() + "'");
            return false;
        }
        return true;
    }

    private static String performRequest(String url, CloseableHttpClient httpClient) throws IOException {
        return (String)httpClient.execute((ClassicHttpRequest)new HttpGet(url), (HttpClientResponseHandler)new BasicHttpClientResponseHandler());
    }
}

