/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy;

import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Transport;
import com.yahoo.log.LogLevel;
import com.yahoo.log.LogSetup;
import com.yahoo.log.event.Event;
import com.yahoo.vespa.config.RawConfig;
import com.yahoo.vespa.config.TimingValues;
import com.yahoo.vespa.config.protocol.JRTServerConfigRequest;
import com.yahoo.vespa.config.proxy.ClientUpdater;
import com.yahoo.vespa.config.proxy.ConfigProxyRpcServer;
import com.yahoo.vespa.config.proxy.ConfigProxyStatistics;
import com.yahoo.vespa.config.proxy.ConfigSourceClient;
import com.yahoo.vespa.config.proxy.DelayedResponseHandler;
import com.yahoo.vespa.config.proxy.DelayedResponses;
import com.yahoo.vespa.config.proxy.MemoryCache;
import com.yahoo.vespa.config.proxy.MemoryCacheConfigClient;
import com.yahoo.vespa.config.proxy.Mode;
import com.yahoo.vespa.config.proxy.RpcConfigSourceClient;
import com.yahoo.vespa.config.proxy.filedistribution.FileDistributionAndUrlDownload;
import com.yahoo.yolean.system.CatchSignals;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProxyServer
implements Runnable {
    private static final int DEFAULT_RPC_PORT = 19090;
    private static final int JRT_TRANSPORT_THREADS = 4;
    static final String DEFAULT_PROXY_CONFIG_SOURCES = "tcp/localhost:19070";
    static final Logger log = Logger.getLogger(ProxyServer.class.getName());
    private final AtomicBoolean signalCaught = new AtomicBoolean(false);
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, (ThreadFactory)new DaemonThreadFactory());
    private final Supervisor supervisor = new Supervisor(new Transport(4));
    private final ClientUpdater clientUpdater;
    private ScheduledFuture<?> delayedResponseScheduler;
    private final ConfigProxyRpcServer rpcServer;
    final DelayedResponses delayedResponses;
    private ConfigSourceSet configSource;
    private volatile ConfigSourceClient configClient;
    private final ConfigProxyStatistics statistics;
    private final TimingValues timingValues;
    private final MemoryCache memoryCache;
    private static final double timingValuesRatio = 0.8;
    private static final TimingValues defaultTimingValues;
    private final boolean delayedResponseHandling;
    private final FileDistributionAndUrlDownload fileDistributionAndUrlDownload;
    private volatile Mode mode = new Mode(Mode.ModeName.DEFAULT);

    private ProxyServer(Spec spec, DelayedResponses delayedResponses, ConfigSourceSet source, ConfigProxyStatistics statistics, TimingValues timingValues, boolean delayedResponseHandling, MemoryCache memoryCache, ConfigSourceClient configClient) {
        this.delayedResponses = delayedResponses;
        this.configSource = source;
        log.log((Level)LogLevel.DEBUG, "Using config source '" + source);
        this.statistics = statistics;
        this.timingValues = timingValues;
        this.delayedResponseHandling = delayedResponseHandling;
        this.memoryCache = memoryCache;
        this.rpcServer = this.createRpcServer(spec);
        this.clientUpdater = new ClientUpdater(this.rpcServer, statistics, delayedResponses);
        this.configClient = this.createClient(this.clientUpdater, delayedResponses, source, timingValues, memoryCache, configClient);
        this.fileDistributionAndUrlDownload = new FileDistributionAndUrlDownload(this.supervisor, source);
    }

    static ProxyServer createTestServer(ConfigSourceSet source) {
        return ProxyServer.createTestServer(source, null, new MemoryCache(), new ConfigProxyStatistics());
    }

    static ProxyServer createTestServer(ConfigSourceSet source, ConfigSourceClient configSourceClient, MemoryCache memoryCache, ConfigProxyStatistics statistics) {
        boolean delayedResponseHandling = false;
        return new ProxyServer(null, new DelayedResponses(statistics), source, statistics, ProxyServer.defaultTimingValues(), false, memoryCache, configSourceClient);
    }

    @Override
    public void run() {
        if (this.rpcServer != null) {
            Thread t = new Thread(this.rpcServer);
            t.setName("RpcServer");
            t.start();
        }
        if (this.delayedResponseHandling) {
            this.delayedResponseScheduler = this.scheduler.scheduleAtFixedRate(new DelayedResponseHandler(this.delayedResponses, this.memoryCache, this.rpcServer), 5L, 1L, TimeUnit.SECONDS);
        } else {
            log.log(LogLevel.INFO, "Running without delayed response handling");
        }
    }

    RawConfig resolveConfig(JRTServerConfigRequest req) {
        this.statistics.incProcessedRequests();
        return this.configClient.getConfig(RawConfig.createFromServerRequest((JRTServerConfigRequest)req), req);
    }

    static boolean configOrGenerationHasChanged(RawConfig config, JRTServerConfigRequest request) {
        return config != null && (!config.hasEqualConfig(request) || config.hasNewerGeneration(request));
    }

    Mode getMode() {
        return this.mode;
    }

    void setMode(String modeName) {
        if (modeName.equals(this.mode.name())) {
            return;
        }
        log.log(LogLevel.INFO, "Switching from " + this.mode + " mode to " + modeName.toLowerCase() + " mode");
        this.mode = new Mode(modeName);
        switch (this.mode.getMode()) {
            case MEMORYCACHE: {
                this.configClient.shutdownSourceConnections();
                this.configClient = new MemoryCacheConfigClient(this.memoryCache);
                break;
            }
            case DEFAULT: {
                this.flush();
                this.configClient = this.createRpcClient();
                break;
            }
            default: {
                throw new IllegalArgumentException("Not able to handle mode '" + modeName + "'");
            }
        }
    }

    private ConfigSourceClient createClient(ClientUpdater clientUpdater, DelayedResponses delayedResponses, ConfigSourceSet source, TimingValues timingValues, MemoryCache memoryCache, ConfigSourceClient client) {
        return client == null ? new RpcConfigSourceClient(source, clientUpdater, memoryCache, timingValues, delayedResponses) : client;
    }

    private ConfigProxyRpcServer createRpcServer(Spec spec) {
        return spec == null ? null : new ConfigProxyRpcServer(this, this.supervisor, spec);
    }

    private RpcConfigSourceClient createRpcClient() {
        return new RpcConfigSourceClient(this.configSource, this.clientUpdater, this.memoryCache, this.timingValues, this.delayedResponses);
    }

    private void setupSignalHandler() {
        CatchSignals.setup((AtomicBoolean)this.signalCaught);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForShutdown() {
        AtomicBoolean atomicBoolean = this.signalCaught;
        synchronized (atomicBoolean) {
            while (!this.signalCaught.get()) {
                try {
                    this.signalCaught.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.stop();
        System.exit(0);
    }

    public static void main(String[] args) {
        LogSetup.clearHandlers();
        LogSetup.initVespaLogging((String)"configproxy");
        Properties properties = ProxyServer.getSystemProperties();
        int port = 19090;
        if (args.length > 0) {
            port = Integer.parseInt(args[0]);
        }
        Event.started((String)"configproxy");
        ConfigProxyStatistics statistics = new ConfigProxyStatistics(properties.eventInterval);
        Thread t = new Thread(statistics);
        t.setName("Metrics generator");
        t.setDaemon(true);
        t.start();
        ConfigSourceSet configSources = new ConfigSourceSet(properties.configSources);
        DelayedResponses delayedResponses = new DelayedResponses(statistics);
        ProxyServer proxyServer = new ProxyServer(new Spec(null, port), delayedResponses, configSources, statistics, ProxyServer.defaultTimingValues(), true, new MemoryCache(), null);
        proxyServer.setupSignalHandler();
        Thread proxyserverThread = new Thread(proxyServer);
        proxyserverThread.setName("configproxy");
        proxyserverThread.start();
        proxyServer.waitForShutdown();
    }

    static Properties getSystemProperties() {
        long eventInterval = Long.getLong("eventinterval", 300L);
        String[] inputConfigSources = System.getProperty("proxyconfigsources", DEFAULT_PROXY_CONFIG_SOURCES).split(",");
        return new Properties(eventInterval, inputConfigSources);
    }

    static TimingValues defaultTimingValues() {
        return defaultTimingValues;
    }

    TimingValues getTimingValues() {
        return this.timingValues;
    }

    ConfigProxyStatistics getStatistics() {
        return this.statistics;
    }

    private synchronized void flush() {
        this.memoryCache.clear();
        this.configClient.cancel();
    }

    void stop() {
        Event.stopping((String)"configproxy", (String)"shutdown");
        if (this.rpcServer != null) {
            this.rpcServer.shutdown();
        }
        if (this.delayedResponseScheduler != null) {
            this.delayedResponseScheduler.cancel(true);
        }
        this.flush();
        if (this.statistics != null) {
            this.statistics.stop();
        }
        this.fileDistributionAndUrlDownload.close();
    }

    MemoryCache getMemoryCache() {
        return this.memoryCache;
    }

    String getActiveSourceConnection() {
        return this.configClient.getActiveSourceConnection();
    }

    List<String> getSourceConnections() {
        return this.configClient.getSourceConnections();
    }

    void updateSourceConnections(List<String> sources) {
        this.configSource = new ConfigSourceSet(sources);
        this.flush();
        this.configClient = this.createRpcClient();
    }

    static {
        TimingValues tv = new TimingValues();
        tv.setUnconfiguredDelay((long)((double)tv.getUnconfiguredDelay() * 0.8)).setConfiguredErrorDelay((long)((double)tv.getConfiguredErrorDelay() * 0.8)).setSubscribeTimeout((long)((double)tv.getSubscribeTimeout() * 0.8)).setConfiguredErrorTimeout(-1L);
        defaultTimingValues = tv;
    }

    static class Properties {
        final long eventInterval;
        final String[] configSources;

        Properties(long eventInterval, String[] configSources) {
            this.eventInterval = eventInterval;
            this.configSources = configSources;
        }
    }
}

