/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy;

import com.yahoo.jrt.Acceptor;
import com.yahoo.jrt.Int32Value;
import com.yahoo.jrt.ListenFailedException;
import com.yahoo.jrt.Method;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.StringArray;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Target;
import com.yahoo.jrt.TargetWatcher;
import com.yahoo.jrt.Value;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.JRTMethods;
import com.yahoo.vespa.config.RawConfig;
import com.yahoo.vespa.config.protocol.JRTConfigRequestFactory;
import com.yahoo.vespa.config.protocol.JRTServerConfigRequest;
import com.yahoo.vespa.config.protocol.JRTServerConfigRequestV3;
import com.yahoo.vespa.config.proxy.DelayedResponse;
import com.yahoo.vespa.config.proxy.MemoryCache;
import com.yahoo.vespa.config.proxy.Mode;
import com.yahoo.vespa.config.proxy.ProxyServer;
import com.yahoo.vespa.config.proxy.RpcServer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigProxyRpcServer
implements Runnable,
TargetWatcher,
RpcServer {
    private static final Logger log = Logger.getLogger(ConfigProxyRpcServer.class.getName());
    private static final int TRACELEVEL = 6;
    private final Spec spec;
    private final Supervisor supervisor;
    private final ProxyServer proxyServer;

    ConfigProxyRpcServer(ProxyServer proxyServer, Supervisor supervisor, Spec spec) {
        this.proxyServer = proxyServer;
        this.spec = spec;
        this.supervisor = supervisor;
        this.declareConfigMethods();
    }

    @Override
    public void run() {
        try {
            Acceptor acceptor = this.supervisor.listen(this.spec);
            log.log((Level)LogLevel.DEBUG, "Ready for requests on " + this.spec);
            this.supervisor.transport().join();
            acceptor.shutdown().join();
        }
        catch (ListenFailedException e) {
            this.proxyServer.stop();
            throw new RuntimeException("Could not listen on " + this.spec, e);
        }
    }

    void shutdown() {
        this.supervisor.transport().shutdown();
    }

    Spec getSpec() {
        return this.spec;
    }

    private void declareConfigMethods() {
        this.supervisor.addMethod(JRTMethods.createConfigV3GetConfigMethod(this::getConfigV3));
        this.supervisor.addMethod(new Method("ping", "", "i", this::ping).methodDesc("ping").returnDesc(0, "ret code", "return code, 0 is OK"));
        this.supervisor.addMethod(new Method("printStatistics", "", "s", this::printStatistics).methodDesc("printStatistics").returnDesc(0, "statistics", "Statistics for server"));
        this.supervisor.addMethod(new Method("listCachedConfig", "", "S", this::listCachedConfig).methodDesc("list cached configs)").returnDesc(0, "data", "string array of configs"));
        this.supervisor.addMethod(new Method("listCachedConfigFull", "", "S", this::listCachedConfigFull).methodDesc("list cached configs with cache content)").returnDesc(0, "data", "string array of configs"));
        this.supervisor.addMethod(new Method("listSourceConnections", "", "S", this::listSourceConnections).methodDesc("list config source connections)").returnDesc(0, "data", "string array of source connections"));
        this.supervisor.addMethod(new Method("invalidateCache", "", "S", this::invalidateCache).methodDesc("list config source connections)").returnDesc(0, "data", "0 if success, 1 otherwise"));
        this.supervisor.addMethod(new Method("updateSources", "s", "s", this::updateSources).methodDesc("update list of config sources").returnDesc(0, "ret", "list of updated config sources"));
        this.supervisor.addMethod(new Method("setMode", "s", "S", this::setMode).methodDesc("Set config proxy mode { default | memorycache }").returnDesc(0, "ret", "0 if success, 1 otherwise as first element, description as second element"));
        this.supervisor.addMethod(new Method("getMode", "", "s", this::getMode).methodDesc("What serving mode the config proxy is in (default, memorycache)").returnDesc(0, "ret", "mode as a string"));
        this.supervisor.addMethod(new Method("dumpCache", "s", "s", this::dumpCache).methodDesc("Dump cache to disk").paramDesc(0, "path", "path to write cache contents to").returnDesc(0, "ret", "Empty string or error message"));
    }

    private void getConfigV3(Request req) {
        log.log((Level)LogLevel.SPAM, () -> "getConfigV3");
        JRTServerConfigRequestV3 request = JRTServerConfigRequestV3.createFromRequest((Request)req);
        if (this.isProtocolVersionSupported((JRTServerConfigRequest)request)) {
            this.preHandle(req);
            this.getConfigImpl((JRTServerConfigRequest)request);
        }
    }

    void ping(Request req) {
        req.returnValues().add((Value)new Int32Value(0));
    }

    void printStatistics(Request req) {
        StringBuilder sb = new StringBuilder();
        sb.append("\nDelayed responses queue size: ");
        sb.append(this.proxyServer.delayedResponses.size());
        sb.append("\nContents: ");
        for (DelayedResponse delayed : this.proxyServer.delayedResponses.responses()) {
            sb.append(delayed.getRequest().toString()).append("\n");
        }
        req.returnValues().add((Value)new StringValue(sb.toString()));
    }

    void listCachedConfig(Request req) {
        this.listCachedConfig(req, false);
    }

    void listCachedConfigFull(Request req) {
        this.listCachedConfig(req, true);
    }

    void listSourceConnections(Request req) {
        String[] ret = new String[]{"Current source: " + this.proxyServer.getActiveSourceConnection(), "All sources:\n" + this.printSourceConnections()};
        req.returnValues().add((Value)new StringArray(ret));
    }

    void updateSources(Request req) {
        String ret;
        String sources = req.parameters().get(0).asString();
        System.out.println(this.proxyServer.getMode());
        if (this.proxyServer.getMode().requiresConfigSource()) {
            this.proxyServer.updateSourceConnections(Arrays.asList(sources.split(",")));
            ret = "Updated config sources to: " + sources;
        } else {
            ret = "Cannot update sources when in '" + this.proxyServer.getMode().name() + "' mode";
        }
        req.returnValues().add((Value)new StringValue(ret));
    }

    void invalidateCache(Request req) {
        this.proxyServer.getMemoryCache().clear();
        String[] s = new String[]{"0", "success"};
        req.returnValues().add((Value)new StringArray(s));
    }

    void setMode(Request req) {
        String suppliedMode = req.parameters().get(0).asString();
        log.log((Level)LogLevel.DEBUG, () -> "Supplied mode=" + suppliedMode);
        String[] s = new String[2];
        if (Mode.validModeName(suppliedMode.toLowerCase())) {
            this.proxyServer.setMode(suppliedMode);
            s[0] = "0";
            s[1] = "success";
        } else {
            s[0] = "1";
            s[1] = "Could not set mode to '" + suppliedMode + "'. Legal modes are '" + Mode.modes() + "'";
        }
        req.returnValues().add((Value)new StringArray(s));
    }

    void getMode(Request req) {
        req.returnValues().add((Value)new StringValue(this.proxyServer.getMode().name()));
    }

    void dumpCache(Request req) {
        MemoryCache memoryCache = this.proxyServer.getMemoryCache();
        req.returnValues().add((Value)new StringValue(memoryCache.dumpCacheToDisk(req.parameters().get(0).asString(), memoryCache)));
    }

    private boolean isProtocolVersionSupported(JRTServerConfigRequest request) {
        Set supportedProtocolVersions = JRTConfigRequestFactory.supportedProtocolVersions();
        if (supportedProtocolVersions.contains(request.getProtocolVersion())) {
            return true;
        }
        String message = "Illegal protocol version " + request.getProtocolVersion() + " in request " + request.getShortDescription() + ", only protocol versions " + supportedProtocolVersions + " are supported";
        log.log((Level)LogLevel.ERROR, message);
        request.addErrorResponse(100109, message);
        return false;
    }

    private void preHandle(Request req) {
        this.proxyServer.getStatistics().incRpcRequests();
        req.detach();
        req.target().addWatcher((TargetWatcher)this);
    }

    private void getConfigImpl(JRTServerConfigRequest request) {
        request.getRequestTrace().trace(6, "Config proxy getConfig()");
        log.log((Level)LogLevel.DEBUG, () -> "getConfig: " + request.getShortDescription() + ",configmd5=" + request.getRequestConfigMd5());
        if (!request.validateParameters()) {
            log.log(LogLevel.WARNING, "Parameters for request " + request + " did not validate: " + request.errorCode() + " : " + request.errorMessage());
            this.returnErrorResponse(request, request.errorCode(), "Parameters for request " + request.getShortDescription() + " did not validate: " + request.errorMessage());
            return;
        }
        try {
            RawConfig config = this.proxyServer.resolveConfig(request);
            if (config == null) {
                log.log((Level)LogLevel.SPAM, () -> "No config received yet for " + request.getShortDescription() + ", not sending response");
            } else if (ProxyServer.configOrGenerationHasChanged(config, request)) {
                this.returnOkResponse(request, config);
            } else {
                log.log((Level)LogLevel.SPAM, "No new config for " + request.getShortDescription() + ", not sending response");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.returnErrorResponse(request, 100200, e.getMessage());
        }
    }

    private String printSourceConnections() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.proxyServer.getSourceConnections()) {
            sb.append(s).append("\n");
        }
        return sb.toString();
    }

    final void listCachedConfig(Request req, boolean full) {
        MemoryCache cache = this.proxyServer.getMemoryCache();
        Object[] ret = new String[cache.size()];
        int i = 0;
        for (RawConfig config : cache.values()) {
            StringBuilder sb = new StringBuilder();
            sb.append(config.getNamespace());
            sb.append(".");
            sb.append(config.getName());
            sb.append(",");
            sb.append(config.getConfigId());
            sb.append(",");
            sb.append(config.getGeneration());
            sb.append(",");
            sb.append(config.getConfigMd5());
            if (full) {
                sb.append(",");
                sb.append(config.getPayload());
            }
            ret[i] = sb.toString();
            ++i;
        }
        Arrays.sort(ret);
        req.returnValues().add((Value)new StringArray((String[])ret));
    }

    public void notifyTargetInvalid(Target target) {
        log.log((Level)LogLevel.DEBUG, () -> "Target invalid " + target);
        Iterator<DelayedResponse> it = this.proxyServer.delayedResponses.responses().iterator();
        while (it.hasNext()) {
            DelayedResponse delayed = it.next();
            JRTServerConfigRequest request = delayed.getRequest();
            if (!request.getRequest().target().equals(target)) continue;
            log.log((Level)LogLevel.DEBUG, () -> "Removing " + request.getShortDescription());
            it.remove();
        }
    }

    @Override
    public void returnOkResponse(JRTServerConfigRequest request, RawConfig config) {
        request.getRequestTrace().trace(6, "Config proxy returnOkResponse()");
        request.addOkResponse(config.getPayload(), config.getGeneration(), config.isInternalRedeploy(), config.getConfigMd5());
        log.log((Level)LogLevel.DEBUG, () -> "Return response: " + request.getShortDescription() + ",configMd5=" + config.getConfigMd5() + ",generation=" + config.getGeneration());
        log.log((Level)LogLevel.SPAM, () -> "Config payload in response for " + request.getShortDescription() + ":" + config.getPayload());
        try {
            request.getRequest().returnRequest();
        }
        catch (IllegalStateException e) {
            log.log((Level)LogLevel.DEBUG, () -> "Something bad happened when sending response for '" + request.getShortDescription() + "':" + e.getMessage());
        }
    }

    @Override
    public void returnErrorResponse(JRTServerConfigRequest request, int errorCode, String message) {
        request.getRequestTrace().trace(6, "Config proxy returnErrorResponse()");
        request.addErrorResponse(errorCode, message);
        request.getRequest().returnRequest();
    }
}

