/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy;

import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.ConfigCacheKey;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.RawConfig;
import com.yahoo.vespa.config.protocol.JRTServerConfigRequest;
import com.yahoo.vespa.config.proxy.ConfigSourceClient;
import com.yahoo.vespa.config.proxy.DelayedResponses;
import com.yahoo.vespa.config.proxy.MemoryCache;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class MemoryCacheConfigClient
implements ConfigSourceClient {
    private static final Logger log = Logger.getLogger(MemoryCacheConfigClient.class.getName());
    private final MemoryCache cache;
    private final DelayedResponses delayedResponses = new DelayedResponses();

    MemoryCacheConfigClient(MemoryCache cache) {
        this.cache = cache;
    }

    @Override
    public RawConfig getConfig(RawConfig input, JRTServerConfigRequest request) {
        log.log((Level)LogLevel.DEBUG, () -> "Getting config from cache");
        ConfigKey key = input.getKey();
        RawConfig cached = this.cache.get(new ConfigCacheKey(key, input.getDefMd5()));
        if (cached != null) {
            log.log((Level)LogLevel.DEBUG, () -> "Found config " + key + " in cache");
            return cached;
        }
        return null;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void shutdownSourceConnections() {
    }

    @Override
    public String getActiveSourceConnection() {
        return "N/A";
    }

    @Override
    public List<String> getSourceConnections() {
        return Collections.singletonList("N/A");
    }

    @Override
    public void updateSubscribers(RawConfig config) {
    }

    @Override
    public DelayedResponses delayedResponses() {
        return this.delayedResponses;
    }
}

