/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy;

import com.yahoo.vespa.config.proxy.ConfigProxyStatistics;
import com.yahoo.vespa.config.proxy.DelayedResponse;
import java.util.concurrent.DelayQueue;

class DelayedResponses {
    private final DelayQueue<DelayedResponse> delayedResponses = new DelayQueue();
    private final ConfigProxyStatistics statistics;

    DelayedResponses(ConfigProxyStatistics statistics) {
        this.statistics = statistics;
    }

    void add(DelayedResponse response) {
        this.delayedResponses.add(response);
        this.statistics.delayedResponses(this.delayedResponses.size());
    }

    boolean remove(DelayedResponse response) {
        this.statistics.decDelayedResponses();
        return this.delayedResponses.remove(response);
    }

    DelayQueue<DelayedResponse> responses() {
        return this.delayedResponses;
    }

    int size() {
        return this.responses().size();
    }
}

