/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy;

import com.yahoo.config.subscription.ConfigSource;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.config.subscription.impl.GenericConfigHandle;
import com.yahoo.config.subscription.impl.GenericConfigSubscriber;
import com.yahoo.config.subscription.impl.JRTConfigRequester;
import com.yahoo.log.LogLevel;
import com.yahoo.protect.Process;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.RawConfig;
import com.yahoo.vespa.config.TimingValues;
import com.yahoo.vespa.config.proxy.ClientUpdater;
import com.yahoo.vespa.config.proxy.MemoryCache;
import com.yahoo.vespa.config.proxy.Subscriber;
import com.yahoo.yolean.Exceptions;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UpstreamConfigSubscriber
implements Subscriber {
    private static final Logger log = Logger.getLogger(UpstreamConfigSubscriber.class.getName());
    private final RawConfig config;
    private final ClientUpdater clientUpdater;
    private final ConfigSource configSourceSet;
    private final TimingValues timingValues;
    private final Map<ConfigSourceSet, JRTConfigRequester> requesterPool;
    private final MemoryCache memoryCache;
    private GenericConfigSubscriber subscriber;
    private GenericConfigHandle handle;

    UpstreamConfigSubscriber(RawConfig config, ClientUpdater clientUpdater, ConfigSource configSourceSet, TimingValues timingValues, Map<ConfigSourceSet, JRTConfigRequester> requesterPool, MemoryCache memoryCache) {
        this.config = config;
        this.clientUpdater = clientUpdater;
        this.configSourceSet = configSourceSet;
        this.timingValues = timingValues;
        this.requesterPool = requesterPool;
        this.memoryCache = memoryCache;
    }

    void subscribe() {
        this.subscriber = new GenericConfigSubscriber(this.requesterPool);
        ConfigKey key = this.config.getKey();
        this.handle = this.subscriber.subscribe(new ConfigKey(key.getName(), key.getConfigId(), key.getNamespace()), this.config.getDefContent(), this.configSourceSet, this.timingValues);
    }

    @Override
    public void run() {
        do {
            if (!this.subscriber.nextGeneration()) continue;
            try {
                this.updateWithNewConfig(this.handle);
            }
            catch (Exception e) {
                log.log(LogLevel.WARNING, "Got exception: " + Exceptions.toMessageString((Throwable)e));
            }
            catch (Throwable e) {
                Process.logAndDie((String)("Got error, exiting: " + Exceptions.toMessageString((Throwable)e)));
            }
        } while (!this.subscriber.isClosed());
    }

    private void updateWithNewConfig(GenericConfigHandle handle) {
        RawConfig newConfig = handle.getRawConfig();
        if (log.isLoggable((Level)LogLevel.DEBUG)) {
            log.log((Level)LogLevel.DEBUG, "config to be returned for '" + newConfig.getKey() + "', generation=" + newConfig.getGeneration() + ", payload=" + newConfig.getPayload());
        }
        this.memoryCache.put(newConfig);
        this.clientUpdater.updateSubscribers(newConfig);
    }

    @Override
    public void cancel() {
        if (this.subscriber != null) {
            this.subscriber.close();
        }
    }
}

