/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy;

import com.yahoo.vespa.config.protocol.JRTServerConfigRequest;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class DelayedResponse
implements Delayed {
    private final JRTServerConfigRequest request;
    private final long returnTime;

    public DelayedResponse(JRTServerConfigRequest request) {
        this(request, System.currentTimeMillis() + request.getTimeout());
    }

    DelayedResponse(JRTServerConfigRequest request, long returnTime) {
        this.request = request;
        this.returnTime = returnTime;
    }

    public Long getReturnTime() {
        return this.returnTime;
    }

    public JRTServerConfigRequest getRequest() {
        return this.request;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return this.returnTime - System.currentTimeMillis();
    }

    @Override
    public int compareTo(Delayed delayed) {
        if (this == delayed) {
            return 0;
        }
        if (delayed instanceof DelayedResponse) {
            if (this.returnTime < ((DelayedResponse)delayed).getReturnTime()) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.request.getShortDescription()).append(", delayLeft=").append(this.getDelay(TimeUnit.MILLISECONDS)).append(" ms");
        return sb.toString();
    }
}

