/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.component.Version;
import com.yahoo.config.provision.DockerImage;
import java.util.Objects;
import java.util.Optional;

public final class ClusterSpec {
    private final Type type;
    private final Id id;
    private final Optional<Group> groupId;
    private final Version vespaVersion;
    private final boolean exclusive;
    private final Optional<Id> combinedId;
    private final Optional<DockerImage> dockerImageRepo;
    private final boolean stateful;

    private ClusterSpec(Type type, Id id, Optional<Group> groupId, Version vespaVersion, boolean exclusive, Optional<Id> combinedId, Optional<DockerImage> dockerImageRepo, boolean stateful) {
        this.type = type;
        this.id = id;
        this.groupId = groupId;
        this.vespaVersion = Objects.requireNonNull(vespaVersion);
        this.exclusive = exclusive;
        if (type == Type.combined) {
            if (combinedId.isEmpty()) {
                throw new IllegalArgumentException("combinedId must be set for cluster of type " + type);
            }
        } else if (combinedId.isPresent()) {
            throw new IllegalArgumentException("combinedId must be empty for cluster of type " + type);
        }
        this.combinedId = combinedId;
        if (dockerImageRepo.isPresent() && dockerImageRepo.get().tag().isPresent()) {
            throw new IllegalArgumentException("dockerImageRepo is not allowed to have a tag");
        }
        this.dockerImageRepo = dockerImageRepo;
        if (type.isContent() && !stateful) {
            throw new IllegalArgumentException("Cluster of type " + type + " must be stateful");
        }
        this.stateful = stateful;
    }

    public Type type() {
        return this.type;
    }

    public Id id() {
        return this.id;
    }

    public Optional<DockerImage> dockerImageRepo() {
        return this.dockerImageRepo;
    }

    public Optional<String> dockerImage() {
        return this.dockerImageRepo.map(repo -> repo.withTag(this.vespaVersion).asString());
    }

    public Version vespaVersion() {
        return this.vespaVersion;
    }

    public Optional<Group> group() {
        return this.groupId;
    }

    public Optional<Id> combinedId() {
        return this.combinedId;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public boolean isStateful() {
        return this.stateful;
    }

    public ClusterSpec with(Optional<Group> newGroup) {
        return new ClusterSpec(this.type, this.id, newGroup, this.vespaVersion, this.exclusive, this.combinedId, this.dockerImageRepo, this.stateful);
    }

    public ClusterSpec exclusive(boolean exclusive) {
        return new ClusterSpec(this.type, this.id, this.groupId, this.vespaVersion, exclusive, this.combinedId, this.dockerImageRepo, this.stateful);
    }

    public static Builder request(Type type, Id id) {
        return new Builder(type, id, false);
    }

    public static Builder specification(Type type, Id id) {
        return new Builder(type, id, true);
    }

    public String toString() {
        return this.type + " " + this.id + " " + this.groupId.map(group -> group + " ").orElse("") + this.vespaVersion + this.dockerImageRepo.map(repo -> " " + repo).orElse("");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterSpec that = (ClusterSpec)o;
        return this.exclusive == that.exclusive && this.stateful == that.stateful && this.type == that.type && this.id.equals(that.id) && this.groupId.equals(that.groupId) && this.vespaVersion.equals((Object)that.vespaVersion) && this.combinedId.equals(that.combinedId) && this.dockerImageRepo.equals(that.dockerImageRepo);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.id, this.groupId, this.vespaVersion, this.exclusive, this.combinedId, this.dockerImageRepo, this.stateful});
    }

    public boolean satisfies(ClusterSpec other) {
        if (!other.id.equals(this.id)) {
            return false;
        }
        if (other.type.isContent() || this.type.isContent()) {
            return other.type.isContent() == this.type.isContent();
        }
        return other.type.equals((Object)this.type);
    }

    public static final class Group {
        private final int index;

        private Group(int index) {
            this.index = index;
        }

        public static Group from(int index) {
            return new Group(index);
        }

        public int index() {
            return this.index;
        }

        public String toString() {
            return "group " + this.index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return ((Group)o).index == this.index;
        }

        public int hashCode() {
            return this.index;
        }
    }

    public static final class Id {
        private final String id;

        public Id(String id) {
            this.id = Objects.requireNonNull(id, "Id cannot be null");
        }

        public static Id from(String id) {
            return new Id(id);
        }

        public String value() {
            return this.id;
        }

        public String toString() {
            return "cluster '" + this.id + "'";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return ((Id)o).id.equals(this.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }

    public static enum Type {
        admin,
        container,
        content,
        combined;


        public boolean isContent() {
            return this == content || this == combined;
        }

        public boolean isContainer() {
            return this == container || this == combined;
        }

        public static Type from(String typeName) {
            switch (typeName) {
                case "admin": {
                    return admin;
                }
                case "container": {
                    return container;
                }
                case "content": {
                    return content;
                }
                case "combined": {
                    return combined;
                }
            }
            throw new IllegalArgumentException("Illegal cluster type '" + typeName + "'");
        }
    }

    public static class Builder {
        private final Type type;
        private final Id id;
        private final boolean specification;
        private boolean stateful;
        private Optional<Group> groupId = Optional.empty();
        private Optional<DockerImage> dockerImageRepo = Optional.empty();
        private Version vespaVersion;
        private boolean exclusive = false;
        private Optional<Id> combinedId = Optional.empty();

        private Builder(Type type, Id id, boolean specification) {
            this.type = type;
            this.id = id;
            this.specification = specification;
            this.stateful = type.isContent();
        }

        public ClusterSpec build() {
            if (this.specification) {
                if (this.groupId.isEmpty()) {
                    throw new IllegalArgumentException("groupId is required to be set when creating a ClusterSpec with specification()");
                }
                if (this.vespaVersion == null) {
                    throw new IllegalArgumentException("vespaVersion is required to be set when creating a ClusterSpec with specification()");
                }
            } else if (this.groupId.isPresent()) {
                throw new IllegalArgumentException("groupId is not allowed to be set when creating a ClusterSpec with request()");
            }
            return new ClusterSpec(this.type, this.id, this.groupId, this.vespaVersion, this.exclusive, this.combinedId, this.dockerImageRepo, this.stateful);
        }

        public Builder group(Group groupId) {
            this.groupId = Optional.ofNullable(groupId);
            return this;
        }

        public Builder vespaVersion(Version vespaVersion) {
            this.vespaVersion = vespaVersion;
            return this;
        }

        public Builder vespaVersion(String vespaVersion) {
            this.vespaVersion = Version.fromString((String)vespaVersion);
            return this;
        }

        public Builder exclusive(boolean exclusive) {
            this.exclusive = exclusive;
            return this;
        }

        public Builder combinedId(Optional<Id> combinedId) {
            this.combinedId = combinedId;
            return this;
        }

        public Builder dockerImageRepository(Optional<DockerImage> dockerImageRepo) {
            this.dockerImageRepo = dockerImageRepo;
            return this;
        }

        public Builder stateful(boolean stateful) {
            this.stateful = stateful;
            return this;
        }
    }
}

