/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.NodeFlavors;
import com.yahoo.config.provision.RegionName;
import com.yahoo.config.provision.SystemName;
import java.util.Optional;

public class Zone {
    private final Environment environment;
    private final RegionName region;
    private final SystemName systemName;
    private final FlavorDefaults flavorDefaults;
    private final Optional<NodeFlavors> nodeFlavors;

    @Inject
    public Zone(ConfigserverConfig configserverConfig, NodeFlavors nodeFlavors) {
        this(SystemName.from(configserverConfig.system()), Environment.from(configserverConfig.environment()), RegionName.from(configserverConfig.region()), new FlavorDefaults(configserverConfig), nodeFlavors);
    }

    public Zone(Environment environment, RegionName region) {
        this(SystemName.defaultSystem(), environment, region, "default");
    }

    public Zone(SystemName systemName, Environment environment, RegionName region) {
        this(systemName, environment, region, "default");
    }

    public Zone(SystemName system, Environment environment, RegionName region, String defaultFlavor) {
        this(system, environment, region, new FlavorDefaults(defaultFlavor), null);
    }

    private Zone(SystemName systemName, Environment environment, RegionName region, FlavorDefaults flavorDefaults, NodeFlavors nodeFlavors) {
        this.environment = environment;
        this.region = region;
        this.flavorDefaults = flavorDefaults;
        this.systemName = systemName;
        this.nodeFlavors = Optional.ofNullable(nodeFlavors);
    }

    public Environment environment() {
        return this.environment;
    }

    public RegionName region() {
        return this.region;
    }

    public SystemName system() {
        return this.systemName;
    }

    public String defaultFlavor(ClusterSpec.Type clusterType) {
        return this.flavorDefaults.flavor(clusterType);
    }

    public Optional<NodeFlavors> nodeFlavors() {
        return this.nodeFlavors;
    }

    public static Zone defaultZone() {
        return new Zone(SystemName.defaultSystem(), Environment.defaultEnvironment(), RegionName.defaultName());
    }

    public String toString() {
        return "zone " + (Object)((Object)this.environment) + "." + this.region;
    }

    public int hashCode() {
        return this.environment().hashCode() + 7 * this.region.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Zone)) {
            return false;
        }
        Zone other = (Zone)o;
        if (this.environment() != other.environment()) {
            return false;
        }
        return this.region.equals(other.region);
    }

    private static class FlavorDefaults {
        private final String defaultFlavor;
        private final Optional<String> adminFlavor;
        private final Optional<String> containerFlavor;
        private final Optional<String> contentFlavor;

        public FlavorDefaults(String defaultFlavor) {
            this(defaultFlavor, Optional.empty(), Optional.empty(), Optional.empty());
        }

        public FlavorDefaults(String defaultFlavor, Optional<String> adminFlavor, Optional<String> containerFlavor, Optional<String> contentFlavor) {
            this.defaultFlavor = defaultFlavor;
            this.adminFlavor = adminFlavor;
            this.containerFlavor = containerFlavor;
            this.contentFlavor = contentFlavor;
        }

        public FlavorDefaults(ConfigserverConfig config) {
            this(config.defaultFlavor(), FlavorDefaults.emptyIfDefault(config.defaultAdminFlavor()), FlavorDefaults.emptyIfDefault(config.defaultContainerFlavor()), FlavorDefaults.emptyIfDefault(config.defaultContentFlavor()));
        }

        private static Optional<String> emptyIfDefault(String value) {
            if (Strings.isNullOrEmpty((String)value)) {
                return Optional.empty();
            }
            if (value.equals("default")) {
                return Optional.empty();
            }
            return Optional.of(value);
        }

        public String flavor(ClusterSpec.Type clusterType) {
            switch (clusterType) {
                case admin: {
                    return this.adminFlavor.orElse(this.defaultFlavor);
                }
                case container: {
                    return this.containerFlavor.orElse(this.defaultFlavor);
                }
                case content: {
                    return this.contentFlavor.orElse(this.defaultFlavor);
                }
            }
            return this.defaultFlavor;
        }
    }
}

