/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.config.provision.NodeType;
import java.util.Optional;

public final class Capacity {
    private final int nodeCount;
    private final boolean required;
    private final Optional<String> flavor;
    private final NodeType type;

    private Capacity(int nodeCount, boolean required, Optional<String> flavor, NodeType type) {
        this.nodeCount = nodeCount;
        this.flavor = flavor;
        this.required = required;
        this.type = type;
    }

    public int nodeCount() {
        return this.nodeCount;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Optional<String> flavor() {
        return this.flavor;
    }

    public NodeType type() {
        return this.type;
    }

    public String toString() {
        return this.nodeCount + " nodes " + (this.flavor.isPresent() ? "of flavor " + this.flavor.get() : "(default flavor)");
    }

    public static Capacity fromNodeCount(int capacity) {
        return Capacity.fromNodeCount(capacity, Optional.empty());
    }

    public static Capacity fromNodeCount(int nodeCount, String flavor) {
        return Capacity.fromNodeCount(nodeCount, Optional.of(flavor));
    }

    public static Capacity fromNodeCount(int nodeCount, Optional<String> flavor) {
        return new Capacity(nodeCount, false, flavor, NodeType.tenant);
    }

    public static Capacity fromRequiredNodeCount(int nodeCount) {
        return Capacity.fromRequiredNodeCount(nodeCount, Optional.empty());
    }

    public static Capacity fromRequiredNodeCount(int nodeCount, String flavor) {
        return Capacity.fromRequiredNodeCount(nodeCount, Optional.of(flavor));
    }

    public static Capacity fromRequiredNodeCount(int nodeCount, Optional<String> flavor) {
        return new Capacity(nodeCount, true, flavor, NodeType.tenant);
    }

    public static Capacity fromNodeCount(int nodeCount, Optional<String> flavor, boolean required) {
        return new Capacity(nodeCount, required, flavor, NodeType.tenant);
    }

    public static Capacity fromRequiredNodeType(NodeType type) {
        return new Capacity(0, true, Optional.empty(), type);
    }
}

