/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.Attribute;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.document.Sorting;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class SortingSettings
extends Processor {
    public SortingSettings(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (!validate) {
            return;
        }
        for (SDField field : this.schema.allConcreteFields()) {
            for (Attribute attribute : field.getAttributes().values()) {
                Sorting sorting = attribute.getSorting();
                if (sorting.getFunction() == Sorting.Function.UCA) continue;
                if (sorting.getStrength() != null && sorting.getStrength() != Sorting.Strength.PRIMARY) {
                    this.warn(this.schema, field, "Sort strength only works for sort function 'uca'.");
                }
                if (sorting.getLocale() == null || "".equals(sorting.getLocale())) continue;
                this.warn(this.schema, field, "Sort locale only works for sort function 'uca'.");
            }
        }
    }
}

