/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.parser;

import com.yahoo.schema.OnnxModel;
import com.yahoo.schema.RankProfile;
import com.yahoo.schema.document.Stemming;
import com.yahoo.schema.parser.ParsedAnnotation;
import com.yahoo.schema.parser.ParsedBlock;
import com.yahoo.schema.parser.ParsedDocument;
import com.yahoo.schema.parser.ParsedDocumentSummary;
import com.yahoo.schema.parser.ParsedField;
import com.yahoo.schema.parser.ParsedFieldSet;
import com.yahoo.schema.parser.ParsedIndex;
import com.yahoo.schema.parser.ParsedRankProfile;
import com.yahoo.schema.parser.ParsedStruct;
import com.yahoo.searchlib.rankingexpression.Reference;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ParsedSchema
extends ParsedBlock {
    private boolean documentWithoutSchema = false;
    private Boolean rawAsBase64 = null;
    private ParsedDocument myDocument = null;
    private Stemming defaultStemming = null;
    private final List<ImportedField> importedFields = new ArrayList<ImportedField>();
    private final List<OnnxModel> onnxModels = new ArrayList<OnnxModel>();
    private final Map<Reference, RankProfile.Constant> constants = new LinkedHashMap<Reference, RankProfile.Constant>();
    private final List<String> inherited = new ArrayList<String>();
    private final List<String> inheritedByDocument = new ArrayList<String>();
    private final Map<String, ParsedSchema> resolvedInherits = new LinkedHashMap<String, ParsedSchema>();
    private final Map<String, ParsedSchema> allResolvedInherits = new LinkedHashMap<String, ParsedSchema>();
    private final Map<String, ParsedAnnotation> extraAnnotations = new LinkedHashMap<String, ParsedAnnotation>();
    private final Map<String, ParsedDocumentSummary> docSums = new LinkedHashMap<String, ParsedDocumentSummary>();
    private final Map<String, ParsedField> extraFields = new LinkedHashMap<String, ParsedField>();
    private final Map<String, ParsedFieldSet> fieldSets = new LinkedHashMap<String, ParsedFieldSet>();
    private final Map<String, ParsedIndex> extraIndexes = new LinkedHashMap<String, ParsedIndex>();
    private final Map<String, ParsedRankProfile> rankProfiles = new LinkedHashMap<String, ParsedRankProfile>();
    private final Map<String, ParsedStruct> extraStructs = new LinkedHashMap<String, ParsedStruct>();

    public ParsedSchema(String name) {
        super(name, "schema");
    }

    boolean getDocumentWithoutSchema() {
        return this.documentWithoutSchema;
    }

    Optional<Boolean> getRawAsBase64() {
        return Optional.ofNullable(this.rawAsBase64);
    }

    boolean hasDocument() {
        return this.myDocument != null;
    }

    ParsedDocument getDocument() {
        return this.myDocument;
    }

    boolean hasStemming() {
        return this.defaultStemming != null;
    }

    Stemming getStemming() {
        return this.defaultStemming;
    }

    List<ImportedField> getImportedFields() {
        return List.copyOf(this.importedFields);
    }

    List<OnnxModel> getOnnxModels() {
        return List.copyOf(this.onnxModels);
    }

    List<ParsedAnnotation> getAnnotations() {
        return List.copyOf(this.extraAnnotations.values());
    }

    List<ParsedDocumentSummary> getDocumentSummaries() {
        return List.copyOf(this.docSums.values());
    }

    List<ParsedField> getFields() {
        return List.copyOf(this.extraFields.values());
    }

    List<ParsedFieldSet> getFieldSets() {
        return List.copyOf(this.fieldSets.values());
    }

    List<ParsedIndex> getIndexes() {
        return List.copyOf(this.extraIndexes.values());
    }

    List<ParsedStruct> getStructs() {
        return List.copyOf(this.extraStructs.values());
    }

    List<String> getInherited() {
        return List.copyOf(this.inherited);
    }

    List<String> getInheritedByDocument() {
        return List.copyOf(this.inheritedByDocument);
    }

    List<ParsedRankProfile> getRankProfiles() {
        return List.copyOf(this.rankProfiles.values());
    }

    List<ParsedSchema> getResolvedInherits() {
        return List.copyOf(this.resolvedInherits.values());
    }

    List<ParsedSchema> getAllResolvedInherits() {
        return List.copyOf(this.allResolvedInherits.values());
    }

    List<RankProfile.Constant> getConstants() {
        return List.copyOf(this.constants.values());
    }

    public void addAnnotation(ParsedAnnotation annotation) {
        String annName = annotation.name();
        this.verifyThat(!this.extraAnnotations.containsKey(annName), "already has annotation", annName);
        this.extraAnnotations.put(annName, annotation);
    }

    public void addDocument(ParsedDocument document) {
        this.verifyThat(this.myDocument == null, "already has", this.myDocument, "so cannot add", document);
        this.myDocument = document;
    }

    public void setDocumentWithoutSchema() {
        this.documentWithoutSchema = true;
    }

    public void addDocumentSummary(ParsedDocumentSummary docsum) {
        String dsName = docsum.name();
        this.verifyThat(!this.docSums.containsKey(dsName), "already has document-summary", dsName);
        this.docSums.put(dsName, docsum);
    }

    public void addField(ParsedField field) {
        String fieldName = field.name();
        this.verifyThat(!this.extraFields.containsKey(fieldName), "duplicate", fieldName);
        this.verifyThat(this.myDocument == null || !this.myDocument.getFields().containsKey(fieldName), "duplicate " + String.valueOf(field) + ": Also defined as a document field", new Object[0]);
        this.extraFields.put(fieldName, field);
    }

    public void addFieldSet(ParsedFieldSet fieldSet) {
        String fsName = fieldSet.name();
        this.verifyThat(!this.fieldSets.containsKey(fsName), "already has fieldset", fsName);
        this.fieldSets.put(fsName, fieldSet);
    }

    public void addImportedField(String asFieldName, String refFieldName, String foregnFieldName) {
        this.importedFields.add(new ImportedField(asFieldName, refFieldName, foregnFieldName));
    }

    public void addIndex(ParsedIndex index) {
        String idxName = index.name();
        this.verifyThat(!this.extraIndexes.containsKey(idxName), "already has index", idxName);
        this.extraIndexes.put(idxName, index);
    }

    public void add(OnnxModel model) {
        this.onnxModels.add(model);
    }

    public void addRankProfile(ParsedRankProfile profile) {
        String rpName = profile.name();
        this.verifyThat(!this.rankProfiles.containsKey(rpName), "already has rank-profile", rpName);
        this.rankProfiles.put(rpName, profile);
    }

    public void add(RankProfile.Constant constant) {
        this.constants.put(constant.name(), constant);
    }

    public void addStruct(ParsedStruct struct) {
        String sName = struct.name();
        this.verifyThat(!this.extraStructs.containsKey(sName), "already has struct", sName);
        this.extraStructs.put(sName, struct);
    }

    public void enableRawAsBase64(boolean value) {
        this.rawAsBase64 = value;
    }

    public void inherit(String other) {
        this.inherited.add(other);
    }

    void inheritByDocument(String other) {
        this.inheritedByDocument.add(other);
    }

    public void setStemming(Stemming value) {
        this.verifyThat(this.defaultStemming == null || this.defaultStemming == value, "already has stemming", new Object[]{this.defaultStemming, "cannot also set", value});
        this.defaultStemming = value;
    }

    void resolveInherit(String name, ParsedSchema parsed) {
        this.verifyThat(this.inherited.contains(name), "resolveInherit for non-inherited name", name);
        this.verifyThat(name.equals(parsed.name()), "resolveInherit name mismatch for", name);
        this.verifyThat(!this.resolvedInherits.containsKey(name), "double resolveInherit for", name);
        this.resolvedInherits.put(name, parsed);
        ParsedSchema old = this.allResolvedInherits.put("schema " + name, parsed);
        this.verifyThat(old == null || old == parsed, "conflicting resolveInherit for", name);
    }

    void resolveInheritByDocument(String name, ParsedSchema parsed) {
        this.verifyThat(this.inheritedByDocument.contains(name), "resolveInheritByDocument for non-inherited name", name);
        ParsedSchema old = this.allResolvedInherits.put("document " + name, parsed);
        this.verifyThat(old == null || old == parsed, "conflicting resolveInheritByDocument for", name);
    }

    public static class ImportedField {
        public final String asFieldName;
        public final String refFieldName;
        public final String foreignFieldName;

        public ImportedField(String asField, String refField, String foreignField) {
            this.asFieldName = asField;
            this.refFieldName = refField;
            this.foreignFieldName = foreignField;
        }
    }
}

